<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Pessoa;
use App\Models\Crianca;
use App\Models\AnoLetivo;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use App\Models\Turma;
use App\Models\TurmaCrianca;

use Exception;

class CriancaController extends Controller
{
    public function nova_crianca(){
        $crianca = DB::table('pessoas as P')
        ->select('P.bi_cedula')
        ->leftjoin('criancas as C', 'P.id', '=', 'C.id_pessoa')
        ->get();
        return view('Dashboard.pagina.registar_crianca',['crianca'=>$crianca]);
    }

    public function listar_crianca(){
        $criancas = DB::table('pessoas as P')
        ->select(
            'P.id', 'P.foto', 'P.nome_completo', 'P.bi_cedula',
            'P.data_nascimento', 'P.genero',
            'C.responsavel1', 'C.contacto', 'C.endereco',
            'C.grau', 'C.cartao_vacina', 'C.certidao', 'C.imagem',
            DB::raw('TIMESTAMPDIFF(YEAR, P.data_nascimento, CURDATE()) as idade')
        )
        ->rightJoin('criancas as C', 'P.id', '=', 'C.id_pessoa')
        ->get();


        $criancas_total = DB::table('pessoas as P')
        ->rightJoin('criancas as C', 'P.id', '=', 'C.id_pessoa')
        ->selectRaw("
            COUNT(CASE WHEN P.genero = 'M' THEN 1 ELSE NULL END) AS total_masculino,
            COUNT(CASE WHEN P.genero = 'F' THEN 1 ELSE NULL END) AS total_feminino,
            COUNT(C.id) AS total_inscritas
        ")
        ->groupBy('P.genero')
        ->first();



        return view('Dashboard.pagina.listagem_crianca',['criancas'=>$criancas, 'criancas_total' =>$criancas_total]);
    }

    public function increverPost(Request $request){
        try {
            $nomeImage = "null";
            if ($request->hasFile('imagem') && $request->file('imagem')->isValid()) {
                $path = $request->file('imagem')->store('imagem_crianca', 'public');
                $nomeImage = basename($path); // Obtém apenas o nome do arquivo
            }
            $nomeDocumentoCertidao = "null";
            if ($request->hasFile('certidao') && $request->file('certidao')->isValid()) {
                $path = $request->file('certidao')->store('documentos_crianca', 'public');
                $nomeDocumentoCertidao = basename($path); // Obtém apenas o nome do arquivo
            }
            $nomeDocumentoCartao = "null";
            if ($request->hasFile('cartao_vacina') && $request->file('cartao_vacina')->isValid()) {
                $path = $request->file('cartao_vacina')->store('documentos_crianca', 'public');
                $nomeDocumentoCartao = basename($path); // Obtém apenas o nome do arquivo
            }
            DB::beginTransaction();
            $pessoa = new Pessoa();
            $pessoa->nome_completo = $request->nome;
            $pessoa->bi_cedula = $request->cedula;
            $pessoa->data_nascimento = $request->data_nascimento;
            $pessoa->genero = $request->genero;
            $pessoa->save();

            $crianca = new Crianca();
            $crianca->responsavel1 =$request->nome_responsavel;
            $crianca->contacto = $request->telefone;
            $crianca->endereco = $request->endereco;
            $crianca->grau = $request->relacao;
            $crianca->cartao_vacina = $nomeDocumentoCartao;
            $crianca->certidao = $nomeDocumentoCertidao;
            $crianca->imagem = $nomeImage;
            $crianca->id_pessoa = $pessoa->id;
            $crianca->save();

            DB::commit();
            return redirect()->route('listar.crianca')->with('sms', 'Registo efetuado com sucesso');
        } catch (\Throwable $th) {

            DB::rollBack();
            return redirect()->back()->withInput()->withErrors(['Ocorreu um erro de acesso a base de dados']);
        }

    }

    public function perfil_crianca($id){
        $crianca_reg = DB::table('pessoas as P')
        ->select('P.bi_cedula')
        ->leftjoin('criancas as C', 'P.id', '=', 'C.id_pessoa')
        ->get();

        $crianca = DB::table('pessoas as P')
        ->select('P.id','P.nome_completo', 'P.bi_cedula', 'P.data_nascimento','P.genero',
        'C.responsavel1', 'C.contacto',
        'C.endereco',
       'C.grau',
        'C.cartao_vacina',
       'C.certidao',
        'C.imagem',
        'C.id as id_crianca',
        DB::raw('TIMESTAMPDIFF(YEAR, P.data_nascimento, CURDATE()) as idade')
        )
        ->rightjoin('criancas as C', 'P.id', '=', 'C.id_pessoa')
        ->where('P.id','=',$id)
        ->first();

        $ano_letivo = AnoLetivo::where('estado', '=', 'Corrente')->first();
        $inicio_fim = '';
        if ($ano_letivo) {
            $inicio_fim = Carbon::createFromFormat('d/m/Y', $ano_letivo->inicio)->year."/".Carbon::createFromFormat('d/m/Y', $ano_letivo->fim)->year;
        }

        $crianca_matriculada = DB::table('pessoas as P')
        ->select('C.id as id_crianca'
        )
        ->rightjoin('criancas as C', 'P.id', '=', 'C.id_pessoa')
        ->leftjoin('turma_criancas as TC', 'TC.id_crianca', '=', 'C.id')
        ->leftjoin('turmas as T', 'T.id', '=', 'TC.id_turma')
        ->where('P.id','=',$id)
        ->where('T.ano_lectivo','=',$inicio_fim)
        ->first();



        $pagamento = DB::table('pagamentos as P')
        ->select('PE.bi_cedula', 'PE.nome_completo', 'P.comprovativo','P.valor_pago',
            'P.ano_lectivo', 'C.id as crianca_id', 'P.mes_pago', 'P.created_at')
        ->leftJoin('criancas as C', 'P.id_crianca', '=', 'C.id')
        ->leftJoin('pessoas as PE', 'PE.id', '=', 'C.id_pessoa')
        ->where('PE.id','=',$id)
        ->get();

        return view('Dashboard.pagina.perfil_crianca',['pagamento'=>$pagamento,'crianca'=>$crianca, 'crianca_reg' => $crianca_reg,'crianca_matriculada'=>$crianca_matriculada]);


    }

    public function matricula(){


        $ano_letivo = AnoLetivo::where('estado', '=', 'Corrente')->first();
        $inicio_fim = '';
        if ($ano_letivo) {
            $inicio_fim = Carbon::createFromFormat('d/m/Y', $ano_letivo->inicio)->year."/".Carbon::createFromFormat('d/m/Y', $ano_letivo->fim)->year;
        }


       /* $turma = DB::table('turmas as T')
        ->select(
            'id',
            'nome',
            'ano_lectivo',
            'total_criancas',
        )
        ->where('ano_lectivo', '=',  $inicio_fim)
        ->get();*/

        $turma = DB::table('turmas as T')
        ->leftjoin('turma_criancas as TC', 'T.id', '=', 'TC.id_turma')
        ->select(
            'T.id',
            'T.nome',
            'T.ano_lectivo',
            'T.total_criancas',
            DB::raw('COUNT(TC.id_crianca) as total_matriculadas')
        )
        ->where('T.ano_lectivo', '=', $inicio_fim)
        ->groupBy('T.id', 'T.nome', 'T.ano_lectivo', 'T.total_criancas')
        ->get();


        $criancasMatriculadas = DB::table('turmas as T')
        ->join('turma_criancas as TC', 'T.id', '=', 'TC.id_turma')
        ->join('criancas as C', 'TC.id_crianca', '=', 'C.id')
        ->join('pessoas as P', 'C.id_pessoa', '=', 'P.id')
        ->select(
            'P.id as id_pessoa',
            'P.nome_completo',
            'P.bi_cedula',
            'P.data_nascimento',
            'P.genero',
            'C.responsavel1',
            'C.contacto',
            'C.endereco',
            'C.grau',
            'C.cartao_vacina',
            'C.certidao',
            'C.id as id_crianca',
            'C.imagem',
            'T.id as id_turma',
            'T.nome as turma',
            'T.ano_lectivo'
        )
        ->where('T.ano_lectivo', '=', $inicio_fim)
        ->orderBy('P.nome_completo')
        ->get();

        $criancasNaoMatriculadas = DB::table('criancas as C')
        ->join('pessoas as P', 'C.id_pessoa', '=', 'P.id')
        ->leftJoin('turma_criancas as TC', 'C.id', '=', 'TC.id_crianca')
        ->leftJoin('turmas as T', function ($join) use ($inicio_fim) {
            $join->on('T.id', '=', 'TC.id_turma')
                 ->where('T.ano_lectivo', '=', $inicio_fim);
        })
        ->select(
            'P.id as id_pessoa',
            'P.nome_completo',
            'P.bi_cedula',
            'P.data_nascimento',
            'P.genero',
            'C.id as id_crianca'
        )
        ->whereNull('TC.id_crianca') // Filtro: crianças não matriculadas
        ->orderBy('P.nome_completo')
        ->get();


        return view('Dashboard.pagina.matricula',[
            'crianca'=>$criancasMatriculadas,
            'criancasNaoMatriculadas' =>$criancasNaoMatriculadas,
            'turma' => $turma,

             'inicio_fim' =>$inicio_fim]);
    }

    public function matricular_post(Request $request){
        try {
            DB::beginTransaction();
            $matricula = new TurmaCrianca();
            $matricula->id_turma = $request->buscar_turma;
            $matricula->id_crianca = $request->crianca;
            $matricula->save();

            DB::commit();
            return redirect()->route('crianca.matricula')->with('sms', 'Matrícula efectuada com sucesso');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->withInput()->withErrors(['Ocorreu um erro de acesso a base de dados']);
        }
    }

    public function editar_post(Request $request){
        try {

            $nomeImage = "null";
            if ($request->hasFile('imagem') && $request->file('imagem')->isValid()) {
                $path = $request->file('imagem')->store('imagem_crianca', 'public');
                $nomeImage = basename($path); // Obtém apenas o nome do arquivo
            }

            $nomeDocumentoCertidao = "null";
            if ($request->hasFile('certidao') && $request->file('certidao')->isValid()) {
                $path = $request->file('certidao')->store('documentos_crianca', 'public');
                $nomeDocumentoCertidao = basename($path); // Obtém apenas o nome do arquivo
            }

            $nomeDocumentoCartao = "null";
            if ($request->hasFile('cartao_vacina') && $request->file('cartao_vacina')->isValid()) {
                $path = $request->file('cartao_vacina')->store('documentos_crianca', 'public');
                $nomeDocumentoCartao = basename($path); // Obtém apenas o nome do arquivo
            }


            DB::beginTransaction();

            $pessoa = Pessoa::findOrFail($request->id_pessoa);
            $pessoa->nome_completo = $request->nome;
            $pessoa->bi_cedula = $request->cedula;
            $pessoa->data_nascimento = $request->data_nascimento;
            $pessoa->genero = $request->genero;
            $pessoa->save();

            $crianca = Crianca::findOrFail($request->id_crianca);
            $crianca->responsavel1 =$request->nome_responsavel;
            $crianca->contacto = $request->telefone;
            $crianca->endereco = $request->endereco;
            $crianca->grau = $request->relacao;


            if ($request->hasFile('cartao_vacina') && $request->file('cartao_vacina')->isValid()) {
                $crianca->cartao_vacina = $nomeDocumentoCartao;
            }
            if ($request->hasFile('certidao') && $request->file('certidao')->isValid()){
                $crianca->certidao = $nomeDocumentoCertidao;
            }
            if ($request->hasFile('imagem') && $request->file('imagem')->isValid()){
                $crianca->imagem = $nomeImage;
            }

            $crianca->save();

            DB::commit();
            return redirect()->route('perfil.crianca',['id'=>$request->id_pessoa])->with('sms', 'Registo editado com sucesso');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->withInput()->withErrors(['Ocorreu um erro de acesso a base de dados']);
        }
    }

    public function ano_letivo(){
        $anomaximo = Carbon::now();
        $data = $anomaximo->toDateString();

        $ano_letivo = AnoLetivo::orderBy('id', 'desc')->get();

        return view('Dashboard.pagina.ano_letivo',['ano_letivo'=>$ano_letivo, 'data'=>$data ]);
    }


    public function ano_letivo_post(Request $request){
        try {
            $this->desativar_ano_actual();

            $dataFormatada = Carbon::parse($request->ano_letivo)->format('d/m/Y');

            DB::beginTransaction();
            $ano = new AnoLetivo();
            $ano->inicio = $dataFormatada;
            $ano->fim = $request->ano_letivo2;
            $ano->estado = "Corrente";
            $ano->save();

            DB::commit();
            return redirect()->route('ano.letivo')->with('sms', 'Registo efectuado com sucesso');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->withInput()->withErrors(['Ocorreu um erro de acesso a base de dados']);
        }
    }

    public function desativar_ano_actual(){
        $ano = AnoLetivo::where('estado','=','Corrente')->first();
        if($ano != null){
            $ano->estado = 'Passado';
            $ano->save();
        }
    }

    public function transferir(Request $request){

        try {


            $turma = TurmaCrianca::where('id_turma', '=',$request->id_turma_actual)->where('id_crianca', '=',$request->id_crianca)->first();

            DB::beginTransaction();

            $turma->id_turma = $request->turma;
            $turma->save();

            DB::commit();
            return redirect()->route('crianca.matricula')->with('sms', 'Registo actualizado com sucesso');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->withInput()->withErrors(['Ocorreu um erro de acesso a base de dados']);
        }
    }
}
