<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Pessoa;
use App\Models\Crianca;
use App\Models\AnoLetivo;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use App\Models\Turma;
use App\Models\TurmaCrianca;
use App\Models\Pagamento;

class PagamentoController extends Controller
{
    public function pagamento(){

        $crianca = DB::table('pessoas as P')
        ->select('P.bi_cedula', 'P.nome_completo', 'C.id')
        ->rightjoin('criancas as C', 'P.id', '=', 'C.id_pessoa')
        ->get();


        $ano_letivo = AnoLetivo::all();

        return view('Dashboard.pagina.registar_pagamento',['crianca'=>$crianca, 'ano_letivo'=>$ano_letivo]);
    }


    public function pagamento_post(Request $request){

        try {
            $ano_letivo = AnoLetivo::findOrFail($request->ano_letivo);

            $ano = Carbon::createFromFormat('d/m/Y', $ano_letivo->inicio)->year." / ".Carbon::createFromFormat('d/m/Y', $ano_letivo->fim)->year;
    
            $comprovativo = "null";
            if ($request->hasFile('comprovativo') && $request->file('comprovativo')->isValid()) {
                $path = $request->file('comprovativo')->store('documentos_pagamento', 'public');
                $comprovativo = basename($path); // Obtém apenas o nome do arquivo
            }

            DB::beginTransaction();

            $pagamento = new Pagamento();
            $pagamento->id_crianca = $request->crianca;
            $pagamento->ano_lectivo = $ano;
            $pagamento->comprovativo = $comprovativo;
            $pagamento->mes_pago = $request->mes;
            $pagamento->valor_pago = $request->valor_pago;
            $pagamento->save();

            DB::commit();

            return redirect()->route('lista.pagamento')->with('sms', 'Registo efectuado com sucesso');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->withInput()->withErrors(['Ocorreu um erro de acesso a base de dados']);
        }
    }

    public function pagamento_listagem(){

        $pagamento = DB::table('pagamentos as P')
        ->select('PE.bi_cedula', 'PE.nome_completo', 'P.comprovativo','P.valor_pago',
            'P.ano_lectivo', 'C.id as crianca_id', 'P.mes_pago', 'P.created_at')
        ->leftJoin('criancas as C', 'P.id_crianca', '=', 'C.id')
        ->leftJoin('pessoas as PE', 'PE.id', '=', 'C.id_pessoa')
        ->get();

        return view('Dashboard.pagina.listagem_pagamento',['pagamento'=>$pagamento]);
    }

    //dd( $pagamento);

    public function pagamento_divida()
    {
        $dataAtual = now()->format('Y-m-01'); // Primeiro dia do mês atual

        $pagamento = DB::table('criancas as C')
        ->select(
            'PE.bi_cedula',
            'PE.nome_completo',
            'P.comprovativo',
            'P.valor_pago',
            'C.id as crianca_id',
            'P.mes_pago',
            'P.ano_lectivo',
            'P.created_at',
            DB::raw("
                CASE
                    WHEN TIMESTAMPDIFF(MONTH, STR_TO_DATE(CONCAT(P.mes_pago, '-01'), '%Y-%m-%d'), '$dataAtual') <= 1 THEN '0'
                    ELSE '1'
                END AS situacao_divida
            "),
            DB::raw("
                CASE
                    WHEN P.id_crianca IS NULL THEN '0'
                    ELSE '1'
                END AS situacao_divida2
            ")
        )
        ->leftJoin(DB::raw('
            (SELECT id_crianca, MAX(mes_pago) as mes_pago
            FROM pagamentos
            GROUP BY id_crianca) as UltimoPagamento
        '), 'C.id', '=', 'UltimoPagamento.id_crianca')
        ->leftJoin('pagamentos as P', function($join) {
            $join->on('P.id_crianca', '=', 'C.id')
                ->on('P.mes_pago', '=', 'UltimoPagamento.mes_pago');
        })
        ->leftJoin('pessoas as PE', 'PE.id', '=', 'C.id_pessoa')
        ->get();



        return view('Dashboard.pagina.listagem_divida', ['pagamento' => $pagamento]);
    }




}
