<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Sala;
use App\Models\Turma;
use Illuminate\Support\Facades\DB;
use Exception;
use App\Models\Funcionario;
use App\Models\AnoLetivo;
use Carbon\Carbon;


class SalaController extends Controller
{
    public function nova_sala(){
        $nova_ordem = 0;
        $ultimo = $this->pega_ultimo_id_sala();
        if($ultimo == null){
            $nova_ordem = 1;
        }else{
            $nova_ordem = $ultimo->id +1;
        }

        return view('Dashboard.pagina.nova_sala',['nova_ordem' => $nova_ordem ]);
    }


    public function Nova_turma(){
        $sala = Sala::all();
        $ano_letivo = AnoLetivo::where('estado', '=', 'Corrente')->first();

        $inicio_fim = '';
        if ($ano_letivo) {
            $inicio_fim = Carbon::createFromFormat('d/m/Y', $ano_letivo->inicio)->year."/".Carbon::createFromFormat('d/m/Y', $ano_letivo->fim)->year;
        }
        return view('Dashboard.pagina.nova_turma',['sala'=>$sala, 'inicio_fim' =>$inicio_fim]);
    }


    public function pega_ultimo_id_sala(){
        return Sala::latest()->first();
    }

    public function registar_sala_post(Request $request){

        try {
            DB::beginTransaction();

            $sala = new Sala();
            $sala->capacidade = $request->capacidade;
            $sala->save();

            DB::commit();
            return redirect()->route('listar.salas')->with('sms', 'Registo efetuado com sucesso');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->withInput()->withErrors(['Ocorreu um erro de acesso a base de dados']);

        }

    }

    public function  registar_turma_post(Request $request){

        try {
            DB::beginTransaction();

            $turma= new Turma();
            $turma->nome = $request->nome;
            $turma->total_criancas =$request->total;
            $turma->ano_lectivo = $request->ano_letivo;
            $turma->id_sala = $request->sala;
            $turma->save();

            DB::commit();
            return redirect()->route('listar.turmas')->with('sms', 'Registo efetuado com sucesso');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->withInput()->withErrors(['Ocorreu um erro de acesso a base de dados']);

        }

    }

    public function listar_salas(){

        $salas = Sala::all();
        return view('Dashboard.pagina.listagem_salas',['salas' => $salas ]);
    }



    public function listar_turmas(){

        $salas = Sala::all();

        $turma = DB::table('turmas as T')
        ->select(
            'T.id',
            'T.id_sala',
            'T.nome',
            'T.ano_lectivo',
            'T.total_criancas',
            'P.nome_completo as cuidadora',
            'PA.nome_completo as auxiliar', // Nome do segundo funcionário (auxiliar)
            DB::raw('COUNT(TC.id_crianca) as total_matriculadas'),
            DB::raw("COUNT(CASE WHEN PP.genero = 'M' THEN 1 END) AS total_masculino"),
            DB::raw("COUNT(CASE WHEN PP.genero = 'F' THEN 1 END) AS total_femenino")
        )
        ->leftjoin('funcionarios as F', 'F.id', '=', 'T.id_professora')
        ->leftjoin('Pessoas as P', 'P.id', '=', 'F.id_pessoa')  // Cuidadora
        ->leftjoin('funcionarios as FA', 'FA.id', '=', 'T.id_auxiliar') // Novo join para o auxiliar
        ->leftjoin('Pessoas as PA', 'PA.id', '=', 'FA.id_pessoa')  // Auxiliar
        ->leftjoin('turma_criancas as TC', 'T.id', '=', 'TC.id_turma')
        ->leftjoin('criancas as C', 'C.id', '=', 'TC.id_crianca')
        ->leftjoin('Pessoas as PP', 'PP.id', '=', 'C.id_pessoa')
        ->groupBy('T.id','T.id_sala','T.nome','T.ano_lectivo','T.total_criancas', 'P.nome_completo','PA.nome_completo')
        ->get();




        $funcionario = DB::table('pessoas as P')
        ->select('P.id','P.nome_completo',  'P.genero', 'F.funcao', 'F.id as id_func'

        )
        ->leftjoin('funcionarios as F', 'P.id', '=', 'F.id_pessoa')
        ->where('F.funcao','=','Vigilante')
        ->get();

        return view('Dashboard.pagina.listagem_turmas',['turma' => $turma , 'salas'=> $salas,'funcionario'=>$funcionario ]);
    }

    public function editar_sala(Request $request){
        try {
            DB::beginTransaction();

            $sala = Sala::findOrFail($request->id_ordem);

            $sala->capacidade = $request->capacidade;
            $sala->save();

            DB::commit();
            return redirect()->route('listar.salas')->with('sms', 'Actualização efetuada com sucesso');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->withInput()->withErrors(['Ocorreu um erro de acesso a base de dados']);

        }

    }

    public function  editar_turma(Request $request){

        $ano_letivo = "";
        if($request->ano_letivo != null){
            $ano = explode('-', $request->ano_letivo)[0];
            $ano_letivo = $ano."-".$request->ano_letivo2;
        }else{

            $ano_letivo = $request->ano."-".$request->ano_letivo2;
        }

        try {
            DB::beginTransaction();

            $turma = Turma::findOrFail($request->id);
            $turma->nome = $request->nome;
            $turma->id_sala = $request->sala;
            $turma->total_criancas =$request->total;
            $turma->save();

            DB::commit();
            return redirect()->route('listar.turmas')->with('sms', 'Actualização efetuada com sucesso');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->withInput()->withErrors(['Ocorreu um erro de acesso a base de dados']);

        }

    }

    public function adicionar_cuidadora(Request $request){

        try {
            DB::beginTransaction();

            $turma = Turma::findOrFail($request->id_turma);
            $turma->id_professora = $request->cuidadora;
            if($request->auxiliar != null){
                $turma->id_auxiliar = $request->auxiliar;
            }
            $turma->save();

            DB::commit();
            return redirect()->route('listar.turmas')->with('sms', 'Actualização efetuada com sucesso');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->back()->withInput()->withErrors(['Ocorreu um erro de acesso a base de dados']);

        }
    }

    public function adicionar_crianca($id_turma){

        $turma_crianca = DB::table('turmas as T')
        ->select(
            'T.id as id_turma',
            'P.id',
            'P.nome_completo',
            'P.bi_cedula',
            'P.data_nascimento',
            'P.genero',
            'C.responsavel1',
            'C.contacto',
            'C.id as id_crianca',
        )
        ->leftjoin('turma_criancas as TC', 'T.id', '=', 'TC.id_turma')
        ->leftjoin('criancas as C', 'C.id', '=', 'TC.id_crianca')
        ->leftjoin('Pessoas as P', 'P.id', '=', 'C.id_pessoa')
        ->where('T.id','=',$id_turma)
        ->get();

            $turma = Turma::findOrFail($id_turma);
        return view('Dashboard.pagina.listagem_crianca_turma',['turma'=>$turma,'turma_crianca'=>$turma_crianca]);

    }

}
