<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('turmas', function (Blueprint $table) {
            $table->id();
            $table->string('nome');
            $table->string('total_criancas');
            $table->string('ano_lectivo');
            $table->timestamps();

            $table->unsignedBigInteger('id_sala')->nullable() ;
            $table->foreign('id_sala')->references('id')->on('salas')->onDelete('CASCADE');

            $table->unsignedBigInteger('id_professora')->nullable();
            $table->foreign('id_professora')->references('id')->on('funcionarios')->onDelete('CASCADE');

            $table->unsignedBigInteger('id_auxiliar')->nullable();
            $table->foreign('id_auxiliar')->references('id')->on('funcionarios')->onDelete('CASCADE');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('turmas');
    }
};
