<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use App\Models\Pessoa;
use App\Models\Funcionario;
use App\Models\User;
use App\Models\Contacto;

class PessoaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $pessoa = Pessoa::create([
            'nome_completo' => 'Admin do Sistema',
            'bi_cedula' => '123456789UE234',
            'data_nascimento' => '12-12-2012',
            'genero' => 'M',

        ]);

        $funcionario = Funcionario::create([
            'data_admissao' => '06-09-2024',
            'funcao' => 'Administrador',
            'id_pessoa' => $pessoa->id,
        ]);

        Contacto::create([
            'telefone' => '945678789',
            'cidade' => 'Luanda',
            'endereco' => 'Camama',
            'id_funcionario' => $funcionario->id,

        ]);
        User::create([
            'name' => 'Admin',
            'email' => 'admin@creche.com',
            'email_verified_at' => now(),
            'password' => Hash::make('333333'),
            'papel' => 'Admin',
            'id_funcionario' => $funcionario->id,

        ]);
    }
}
