@extends('Dashboard.layout')
@section('conteudo')


<div class="pcoded-content">
    <!-- [ breadcrumb ] start -->
    <div class="page-header">
        <div class="page-block">
            <div class="row align-items-center">
                <div class="col-md-12">
                    <div class="page-header-title">
                        <h5 class="m-b-10">Ano Lectivo</h5>
                    </div>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html"><i class="feather icon-home"></i></a></li>
                        <li class="breadcrumb-item"><a href="#!">Ano Lectivo</a></li>
                        <li class="breadcrumb-item"><a href="#!">Listagem</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12 mb-3">
            <button class="btn btn-primary float-right" data-toggle="modal" data-target="#ano_letivo_modal">Abrir Novo Ano Lectivo</button>
        </div>
        <div class="col-xl-12">

            @if($errors->any())
                <div class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                    <span class="badge badge-pill badge-danger">Erro</span>
                    <ul class="errors">
                        @foreach($errors->all() as $erro)
                            <li> {{ $erro }}</li>
                        @endforeach
                    </ul>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            @endif

            @if(session()->has('sms'))
                <div class="sufee-alert alert with-close alert-success alert-dismissible fade show">
                    <span class="badge badge-pill badge-success">Successo</span>
                    {{ session()->get('sms') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            @endif


            <div class="card">

                <div class="card-header">
                    <h5>Listagem</h5>
               </div>
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered" style="width:100%" >
                            <thead>
                                <tr>
                                    <th>Inicio</th>
                                    <th>Fim</th>
                                    <th>Estado</th>

                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($ano_letivo as $ano)

                                    <tr>

                                        <td> {{$ano->inicio}} </td>
                                        <td>{{$ano->fim}} </td>



                                        <td>
                                            @if($ano->estado == "Corrente")
                                                <span class="badge badge-light-success">{{$ano->estado}}</span>
                                            @else
                                                <span class="badge badge-light-danger">{{$ano->estado}}</span>
                                            @endif
                                        </td>

                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <!-- [ Main Content ] end -->
</div>




<div id="ano_letivo_modal" class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title h4" id="myLargeModalLabel">Novo Ano Lectivo</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">


                <div class="modal-body">
                    <label for="">O registo de um novo ano lectivo, desativa automaticamente o ano lectivo actual</label>
                       <br><br>
                    <form id="formulario" action="{{route('ano_letivo.post')}}" method="post" enctype="multipart/form-data" >
                       @csrf
                       <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="inputZip">Inicio do Ano Lectivo <span style="color: red">*</span></label>
                            <input  type="date" min="{{ $data }}" id="ano_letivo" name="ano_letivo" class="form-control" >
                            <small id="ano_letivo_erro" style="color: red; display: none;"></small>

                        </div>
                        <div class="form-group col-md-6">
                            <label for="inputZip">Fim do Ano Lectivo</label>
                            <input  id="ano_letivo2" name="ano_letivo2" class="form-control" readonly >
                        </div>

                    </div>
                        <div class="modal-footer">
                            <button type="button" class="btn  btn-secondary" data-dismiss="modal">Fechar</button>
                            <button onclick="verificarRegisto()"  class="btn  btn-primary">Confirmar</button>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>
</div>



<script>
function verificarRegisto(){
    event.preventDefault();

    var data = document.getElementById('ano_letivo').value;
    const mensagemErro = document.getElementById('ano_letivo_erro');

    mensagemErro.style.display = 'none';


    if(data ===''){
        mensagemErro.textContent = 'Campu obrigatório';
        mensagemErro.style.display = 'block';
    }else{
        mensagemErro.style.display = 'none';
        document.getElementById('formulario').submit();

    }
}

document.getElementById('ano_letivo').addEventListener('input', function() {

    if (this.value.split("-")[0] < 1000) {
        return;
    }


    const data_selecionada = new Date(this.value);

    const dataAtual = new Date();

    // Calcular limites de idade
    const datamaxima = new Date();
    datamaxima.setFullYear(dataAtual.getFullYear() + 1);

    const mensagemErro = document.getElementById('ano_letivo_erro');

    mensagemErro.style.display = 'none';


    if (data_selecionada < dataAtual) {
        mensagemErro.textContent = 'Novo ano lectivo nao pode ser inferior ao ano actual';
        mensagemErro.style.display = 'block';
        this.value = '';
    } else if (data_selecionada > datamaxima) {

        mensagemErro.textContent = 'Novo ano lectivo não pode ser superior a data actual';
        mensagemErro.style.display = 'block';
        this.value = '';
    }else {
        mensagemErro.style.display = 'none';

        var data = document.getElementById('ano_letivo').value;

        const ano =  parseInt(data.split('-')[0], 10) + 1;

        var mes = data.split('-')[1];
        var dia = data.split('-')[2];

        var ano_letivo = dia+"/"+mes+"/"+ano;

        document.getElementById('ano_letivo2').value = ano_letivo;
    }


    });


</script>


@endsection
