@extends('Dashboard.layout')
@section('conteudo')


<div class="pcoded-content">
    <!-- [ breadcrumb ] start -->
    <div class="page-header">
        <div class="page-block">
            <div class="row align-items-center">
                <div class="col-md-12">
                    <div class="page-header-title">
                        <h5 class="m-b-10">Crianças</h5>
                    </div>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html"><i class="feather icon-home"></i></a></li>
                        <li class="breadcrumb-item"><a href="#!">Crianças</a></li>
                        <li class="breadcrumb-item"><a href="#!">Listagem</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="row">

        <div class="col-xl-12">

            @if($errors->any())

                <div class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                    <span class="badge badge-pill badge-danger">Erro</span>
                    <ul class="errors">
                        @foreach($errors->all() as $erro)
                            <li> {{ $erro }}</li>
                        @endforeach
                    </ul>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
        @endif

            @if(session()->has('sms'))
                <div class="sufee-alert alert with-close alert-success alert-dismissible fade show">
                    <span class="badge badge-pill badge-success">Successo</span>
                    {{ session()->get('sms') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            @endif


            <div class="card">
                <div class="card-header">
                    <h5>Listagem</h5><br>
                    <br><label>Total de Crianças: {{$criancas_total->total_inscritas}}</label><br>
                    <label>Total Masculino: {{$criancas_total->total_masculino}} </label><br>
                    <label>Total Feminino:  {{$criancas_total->total_feminino}}</label>
               </div>
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Foto</th>
                                    <th>Nome</th>
                                    <th>Gênero</th>
                                    <th>Data de Nascimento</th>
                                    <th>Idade</th>
                                    <th>Responsavel</th>
                                    <th>Grau do Responsavel</th>
                                    <th>Contacto</th>
                                    <th>Acção</th>

                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($criancas as $crianca)

                                    <tr>

                                        <td class="text-center">
                                            @if ($crianca->imagem == null)
                                                @if ($crianca->genero== "M" )
                                                    <img src="{{ asset('assets/images/avatar_homem.png') }}"
                                                    alt="avatar"
                                                    style="width: 40px; height: 40px;border-radius: 16px">

                                                @else
                                                    <img src="{{ asset('assets/images/avatar_mulher.jpg') }}"
                                                    alt="avatar"
                                                    style="width: 40px; height: 40px;border-radius: 16px">

                                                @endif
                                            @else
                                                <img src="{{ asset('storage/imagem_crianca/'.$crianca->imagem) }}"
                                                alt="avatar"
                                                style="width: 40px; height: 40px;border-radius: 16px">
                                            @endif
                                        </td>

                                        <td>{{$crianca->nome_completo}} </td>
                                        <td>
                                            @if ( $crianca->genero== "M" )
                                                Masculino
                                            @else
                                                Feminino
                                            @endif
                                        </td>
                                        <td>{{$crianca->data_nascimento}} </td>
                                        <td>{{$crianca->idade}} </td>
                                        <td>{{$crianca->responsavel1}} </td>
                                        <td>{{$crianca->grau}} </td>
                                        <td>{{$crianca->contacto}} </td>
                                        <td>

                                            @can('ver_detalhes_crianca')
                                                <a href="{{route('perfil.crianca',$crianca->id)}}"

                                               >
                                                    <i class="fa-solid fa-eye" style="color: blue;"></i>
                                                </a>
                                            @endcan

                                        </td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>

</div>


<div id="editar_turma" class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title h4" id="myLargeModalLabel">Editar Dados do Transporte</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>

            <div class="modal-body">
                <div  id="sms_erro" class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                    <span class="badge badge-pill badge-danger">Erro</span>
                   Preencha todos os campos obrigatórios.

                </div>

                <div class="modal-body">
                    <form id="formulario_editar" action="{{route('editar.trasnporte')}}" method="post" enctype="multipart/form-data" >
                       @csrf
                       <div class="form-row">

                        <div class="form-group col-md-6">
                            <label for="inputCity">Marca <span style="color: red">*</span></label>
                            <input type="text" id="marca" name="marca" class="form-control" >
                            <input type="text" id="id" name="id" hidden class="form-control" >

                        </div>
                        <div class="form-group col-md-6">
                            <label for="inputCity">Modelo <span style="color: red">*</span></label>
                            <input type="text"  id="modelo" name="modelo" class="form-control" >

                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-4">
                            <label for="inputZip">Matrícula <span style="color: red">*</span></label>
                            <input    type="text" id="matricula" name="matricula" class="form-control" >
                        </div>
                        <div class="form-group col-md-4">
                            <label for="inputZip">Cor <span style="color: red">*</span></label>
                            <input  id="cor" name="cor" class="form-control" >
                        </div>
                        <div class="form-group col-md-4">
                            <label for="inputZip">Capacidade <span style="color: red">*</span></label>
                            <input type="number" min="1" id="capacidade" name="capacidade" class="form-control" >
                        </div>

                    </div>

                        <div class="modal-footer">
                            <button type="button" class="btn  btn-secondary" data-dismiss="modal">Fechar</button>
                            <button onclick="verificarRegisto()"  class="btn  btn-primary">Confirmar</button>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>
</div>

<div id="Eliminar_director" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLiveLabel">Eliminar Transporte</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body text-center">
                <h6 class="mb-0">Deseja realmente eliminar este Transporte <label class="badge badge-light-warning" id="dir_marca"></label> ?</h6>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn  btn-secondary" data-dismiss="modal">Não</button>
                <form action="{{route('eliminar.transporte')}}" method="post" enctype="multipart/form-data" >
                    @csrf
                    <input type="text" id="id_trasporte" name="id_trasporte" hidden>
                    <button type="submit" class="btn  btn-primary">Sim</button>
                </form>

            </div>
        </div>
    </div>
</div>


<script>
    document.getElementById('sms_erro').style.display = 'none';
    function editar_transporte(id, marca,modelo,capacidade, matricula, cor){

        document.getElementById("id").value = id;
        document.getElementById("marca").value = marca;
        document.getElementById("modelo").value  = modelo;
        document.getElementById("matricula").value = matricula;
        document.getElementById("cor").value = cor;
        document.getElementById("capacidade").value = capacidade;
    }


    function verificarRegisto(){
        event.preventDefault();
        var marca = document.getElementById("marca").value;
        var modelo = document.getElementById("modelo").value ;
        var  matricula = document.getElementById("matricula").value;
        var cor = document.getElementById("cor").value;
        var capacidade = document.getElementById("capacidade").value;

        if(capacidade == 0 || marca ==="" || modelo==="" || cor === "" || matricula ===""){
            document.getElementById('sms_erro').style.display = 'block';
        }else{
            document.getElementById('sms_erro').style.display = 'none';
            document.getElementById('formulario_editar').submit();
        }
    }

    function buscar_data(){

        var data = document.getElementById('ano_letivo').value;

        const ano =  parseInt(data.split('-')[0], 10);
        var ano_letivo = ano+1;
        document.getElementById('ano_letivo2').value = ano_letivo;

    }


    function adicionar_professor(id) {
        document.getElementById('sms_erro').style.display = 'none';
        document.getElementById('id_turma').value = id;
    }

    function retornaid_nome(id,nome){
        $('#id_trasporte').val(id);
        document.getElementById("dir_marca").innerHTML = nome;
    }

</script>


@endsection
