@extends('Dashboard.layout')
@section('conteudo')


<div class="pcoded-content">
    <!-- [ breadcrumb ] start -->
    <div class="page-header">
        <div class="page-block">
            <div class="row align-items-center">
                <div class="col-md-12">
                    <div class="page-header-title">
                        <h5 class="m-b-10">Directores</h5>
                    </div>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html"><i class="feather icon-home"></i></a></li>
                        <li class="breadcrumb-item"><a href="#!">Directores</a></li>
                        <li class="breadcrumb-item"><a href="#!">Listagem</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="row">

        <div class="col-xl-12">

            @if($errors->any())
                <div class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                    <span class="badge badge-pill badge-danger">Erro</span>
                    <ul class="errors">
                        @foreach($errors->all() as $erro)
                            <li> {{ $erro }}</li>
                        @endforeach
                    </ul>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
        @endif

            @if(session()->has('sms'))
                <div class="sufee-alert alert with-close alert-success alert-dismissible fade show">
                    <span class="badge badge-pill badge-success">Successo</span>
                    {{ session()->get('sms') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            @endif


            <div class="card">
                <div class="card-header">
                    <h5>Listagem</h5>
               </div>
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered" style="width:100%" >
                            <thead>
                                <tr>
                                    <th>Foto</th>
                                    <th>Nome</th>
                                    <th>BI</th>
                                    <th>Gênero</th>
                                    <th>Função</th>
                                    <th>Telefone</th>
                                    <th>Cidade</th>
                                    <th>Estado</th>
                                    <th>Acção</th>

                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($funcionario as $func)

                                    <tr>
                                        <td class="text-center">
                                            @if ($func->foto == null)
                                                @if ($func->genero== "M" )
                                                    <img src="{{ asset('assets/images/avatar_homem.png') }}"
                                                    alt="avatar"
                                                    style="width: 40px; height: 40px;border-radius: 16px">

                                                @else
                                                    <img src="{{ asset('assets/images/avatar_mulher.jpg') }}"
                                                    alt="avatar"
                                                    style="width: 40px; height: 40px;border-radius: 16px">

                                                @endif
                                            @else
                                                <img src="{{ asset('storage/imagem_funcionario/'.$func->foto) }}"
                                                alt="avatar"
                                                style="width: 40px; height: 40px;border-radius: 16px">
                                            @endif
                                        </td>
                                        <td> {{$func->nome_completo}} </td>
                                        <td>{{$func->bi_cedula}} </td>
                                        <td>
                                            @if ( $func->genero== "M" )
                                                Masculino
                                            @else
                                                Feminino
                                            @endif
                                        </td>
                                        <td>{{$func->funcao}} </td>
                                        <td>{{$func->telefone}} </td>
                                        <td>{{$func->endereco}} </td>
                                        <td>
                                            @if($func->estado == "Actual")
                                            <span class="badge badge-light-success">{{$func->estado}}</span>
                                            @else
                                                <span class="badge badge-light-danger">{{$func->estado}}</span>
                                            @endif
                                        </td>
                                        <td>
                                            <a href="" data-toggle="modal" data-target="#ver_director"
                                            onclick="ver_detalhes({{ json_encode($func->nome_completo) }}, {{ json_encode($func->bi_cedula) }}, {{ json_encode($func->genero) }}, {{ json_encode($func->funcao) }}, {{ json_encode($func->telefone) }}, {{ json_encode($func->endereco) }}, {{ json_encode($func->estado) }}, {{ json_encode($func->data_nascimento) }}, {{ json_encode($func->data_admissao) }}, {{ json_encode($func->cidade) }})">
                                            <i class="fa-solid fa-eye" style="color: rgb(113, 172, 113);"></i>
                                            </a>

                                            @can('gerir_director')
                                                <a href="" data-toggle="modal" data-target="#editar_director"

                                                onclick="editar_director({{ json_encode($func->id) }},{{ json_encode($func->nome_completo) }}, {{ json_encode($func->bi_cedula) }}, {{ json_encode($func->genero) }}, {{ json_encode($func->funcao) }}, {{ json_encode($func->telefone) }}, {{ json_encode($func->endereco) }}, {{ json_encode($func->estado) }}, {{ json_encode($func->data_nascimento) }}, {{ json_encode($func->data_admissao) }}, {{ json_encode($func->cidade) }})"
                                                >
                                                    <i class="fa-solid fa-pen-to-square" style="color: blue;"></i>
                                                </a>
                                                <a href="" onclick="retornaid_nome({{$func->id}}, '{{$func->nome_completo}}')"  data-toggle="modal" data-target="#Eliminar_director">
                                                    <i class="fa-solid fa-trash" style="color: red;"></i>
                                                </a>

                                            @endcan

                                        </td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <!-- [ Main Content ] end -->
</div>




<!-- eliminar director -->
<div id="Eliminar_director" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLiveLabel">Eliminar Director</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body text-center">
                <h6 class="mb-0">Deseja realmente eliminar este Director <label class="badge badge-light-warning" id="dir_nome"></label> ?</h6>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn  btn-secondary" data-dismiss="modal">Não</button>
                <form action="{{route('eliminar.director')}}" method="post" enctype="multipart/form-data" >
                    @csrf
                    <input type="text" id="id_director" name="id_director" hidden>
                    <button type="submit" class="btn  btn-primary">Sim</button>
                </form>

            </div>
        </div>
    </div>
</div>


<!-- editar director -->

<div id="editar_director" class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title h4" id="myLargeModalLabel">Editar Dados do Director</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <div  id="sms_erro3" class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                    <span class="badge badge-pill badge-danger">Erro</span>
                   Número de BI inválido.

                </div>
                <div  id="sms_erro4" class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                    <span class="badge badge-pill badge-danger">Erro</span>
                   Número de Telefone inválido.

                </div>
                <div class="modal-body">
                    <form id="formulario_editar" action="{{route('editar.director')}}" method="post" enctype="multipart/form-data" >
                       @csrf
                        <h6 style="color:black">Dados Pessoais</h6>
                        <hr>
                        <div class="row ">
                            <div class="col-md-6">
                                <input type="text" id="id_editar" name="id_editar" hidden>
                                <div class="form-group">
                                    <label for="recipient-name" class="col-form-label">Nome:</label>
                                    <input type="text" id="nome_e" name="nome_e" class="form-control" >
                                </div>
                                <div class="form-group">
                                    <label for="recipient-name" class="col-form-label">BI:</label>
                                    <input type="text" id="bi_e" name="bi_e" class="form-control" >
                                </div>

                            </div>
                            <div class="col-md-6 ">
                                <div class="form-group">
                                    <label for="recipient-name" class="col-form-label">Género:</label>

                                    <select id="genero_e" name="genero_e"  class="form-control">
                                        <option value="">seleccione o gênero</option>
                                        <option value="M">Masculino</option>
                                        <option value="F">Feminino</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="recipient-name" class="col-form-label">Data de Nascimento:</label>
                                    <input type="date" max="{{date('Y-m-d')}}" id="data_nascimento_e" name="data_nascimento_e" class="form-control">
                                    <small id="data_nascimento_e_erro" style="color: red; display: none;"></small>

                                </div>
                            </div>

                        </div>
                        <h6 style="color:black">Contacto</h6>
                        <hr>
                        <div class="row ">

                            <div class="col-md-4 form-group">
                                <label for="recipient-name" class="col-form-label">Telefone:</label>
                                <input type="text" id="telefone_e" name="telefone_e" class="form-control">
                            </div>
                            <div class="col-md-4 form-group">
                                <label for="recipient-name" class="col-form-label">Cidade:</label>
                                <input type="text" id="cidade_e" name="cidade_e" class="form-control">
                            </div>
                            <div class="col-md-4 form-group">
                                <label for="recipient-name" class="col-form-label">Endereço:</label>
                                <input type="text" id="endereco_e" name="endereco_e" class="form-control">
                            </div>

                        </div>
                        <h6 style="color:black">Dados Profissionais</h6>
                        <hr>
                        <div class="row ">

                            <div class="col-md-4 form-group">
                                <label for="recipient-name" class="col-form-label">Data de Admissão:</label>
                                <input type="date" max="{{date('Y-m-d')}}" id="data_admissao_e" name="data_admissao_e" class="form-control">
                                <small id="data_admissao_e_erro" style="color: red; display: none;"></small>

                            </div>
                            <div class="col-md-4 form-group">
                                <label for="recipient-name" class="col-form-label">Estado:</label>
                                <input type="text" id="estado_e" name="estado_e" readonly class="form-control">
                            </div>
                            <div class="col-md-4 form-group">
                                <label for="recipient-name" class="col-form-label">Função:</label>
                                <input type="text" id="funcao_e" name="funcao_e" readonly class="form-control">
                            </div>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn  btn-secondary" data-dismiss="modal">Fechar</button>
                            <button onclick="verificarRegisto()"  class="btn  btn-primary">Confirmar</button>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>
</div>


<!-- ver director -->

<div id="ver_director" class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title h4" id="myLargeModalLabel">Detalhes do Director</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">

               <div class="row ">
                    <div class="col-md-6 ">
                        <h6 style="color:black">Dados Pessoais</h6>
                        <hr>

                        <label for="">Nome: <label id="nome" style="color: rgb(65, 170, 109)" ></label></label><br>
                        <label for="">BI: <label id="bi" style="color: rgb(65, 170, 109)" ></label></label><br>
                        <label for="">Genero: <label id="genero" style="color: rgb(65, 170, 109)" ></label></label><br>
                        <label for="">Data de Nascimento: <label id="data_nascimento" style="color: rgb(65, 170, 109)" ></label></label>

                    </div>
                    <div class="col-md-6 ">
                        <h6  style="color:black">Contactos</h6>
                        <hr>
                        <label for="">Telefone: <label id="telefone" style="color: rgb(65, 170, 109)" ></label></label><br>
                        <label for="">Cidade: <label id="cidade" style="color: rgb(65, 170, 109)" ></label></label><br>
                        <label for="">Endereço: <label id="endereco" style="color: rgb(65, 170, 109)" ></label></label>
                    </div>
                    <div class="col-md-12">
                        <br><br>
                        <h6 style="color:black">Informações Profissionais</h6>
                        <hr>
                        <label for="">Função: <label id="funcao" style="color: rgb(65, 170, 109)" ></label></label><br>
                        <label for="">Estado: <label id="estado" style="color: rgb(65, 170, 109)" ></label></label><br>
                        <label for="">Data de Admissão: <label id="data_admissao" style="color: rgb(65, 170, 109)" ></label></label>
                    </div>
               </div>
            </div>
        </div>
    </div>
</div>

<script>
  document.getElementById('sms_erro3').style.display = 'none';
  document.getElementById('sms_erro4').style.display = 'none';


    function retornaid_nome(id,nome){
        $('#id_director').val(id);
        document.getElementById("dir_nome").innerHTML = nome;
    }

   function ver_detalhes(nome_completo, bi_cedula, genero, funcao, telefone , endereco , estado, data_nascimento, data_admissao, cidade){

        document.getElementById("nome").innerHTML = nome_completo;
        document.getElementById("bi").innerHTML = bi_cedula ;
        if(genero==="M"){
            document.getElementById("genero").innerHTML = 'Masculino';
        }else{
            document.getElementById("genero").innerHTML = 'Feminino';
        }

        document.getElementById("funcao").innerHTML = funcao ;
        document.getElementById("telefone").innerHTML = telefone;
        document.getElementById("endereco").innerHTML = endereco;
        document.getElementById("estado").innerHTML = estado;
        document.getElementById("data_nascimento").innerHTML = data_nascimento;
        document.getElementById("data_admissao").innerHTML = data_admissao;
        document.getElementById("cidade").innerHTML = cidade ;
   }

    function editar_director(id, nome_completo, bi_cedula, genero, funcao, telefone , endereco , estado, data_nascimento, data_admissao, cidade){
        document.getElementById("id_editar").value = id;
        document.getElementById("nome_e").value = nome_completo;
        document.getElementById("bi_e").value = bi_cedula ;
        document.getElementById("genero_e").value = genero;
        document.getElementById("funcao_e").value = funcao ;
        document.getElementById("telefone_e").value = telefone;
        document.getElementById("endereco_e").value = endereco;
        document.getElementById("estado_e").value = estado;
        document.getElementById("data_nascimento_e").value = data_nascimento;
        document.getElementById("data_admissao_e").value = data_admissao;
        document.getElementById("cidade_e").value = cidade ;
    }


    function verificarBI(bi) {

        const padrao = /^[0-9]{9}(BO|BA|BE|CA|CC|KN|KS|CE|HO|HA|LA|LN|LS|ME|MO|NA|UE|ZA)[0-9]{3}$/;
        bi = bi.toUpperCase();

        if (bi != "" && bi.length === 14) {
            if (padrao.test(bi)) {

                return true;
            }

        }

        return false;
    }

    function verificarTelefone(telefone) {

        const padrao = /^(9)[0-9]{8}$/;

        if (telefone !="" && padrao.test(telefone)) {

            return true;
        }

        return false;
    }

    function verificarRegisto(){
        event.preventDefault();


        var bi = document.getElementById('bi_e').value;
        var telefone = document.getElementById('telefone_e').value;


        if(verificarBI(bi) === false){

            document.getElementById('sms_erro3').style.display = 'block';
        }else{

            document.getElementById('sms_erro3').style.display = 'none';
        }

        if(verificarTelefone(telefone)=== false){
            document.getElementById('sms_erro4').style.display = 'block';
        }else{
            document.getElementById('sms_erro4').style.display = 'none';
        }

        if(verificarBI(bi)===true && verificarTelefone(telefone)===true){
            document.getElementById('formulario_editar').submit();
        }


    }






    document.getElementById('data_nascimento_e').addEventListener('input', function() {

if (this.value.split("-")[0] < 1000) {
    return;
}

const dataNascimento = new Date(this.value);
    const dataAtual = new Date();

    // Calcular limites de idade
    const dataMinima = new Date();
    dataMinima.setFullYear(dataAtual.getFullYear() - 70); // 70 anos atrás

    const dataMaxima = new Date();
    dataMaxima.setFullYear(dataAtual.getFullYear() - 30); // 17 anos atrás

    const mensagemErro = document.getElementById('data_nascimento_e_erro');

    // Verifica se a data é válida
    if (isNaN(dataNascimento.getTime())) {
        mensagemErro.textContent = 'Data inválida. Por favor, insira uma data válida.';
        mensagemErro.style.display = 'block';
        this.value = '';
        return;
    }

    if (dataNascimento < dataMinima) {
        mensagemErro.textContent = 'A idade máxima permitida é de 70 anos.';
        mensagemErro.style.display = 'block';
        this.value = '';
    } else if (dataNascimento > dataMaxima) {
        mensagemErro.textContent = 'A idade mínima permitida é de 30 anos.';
        mensagemErro.style.display = 'block';
        this.value = '';
    } else {
        mensagemErro.style.display = 'none';
    }
});


document.getElementById('data_admissao_e').addEventListener('change', function() {
const dataNascimentoInput = document.getElementById('data_nascimento').value;
const dataAdmissaoInput = this.value;
const mensagemErro = document.getElementById('data_admissao_e_erro');
if (this.value.split("-")[0] < 1000) {
    return;
}


// Se a data de nascimento não foi preenchida, não faz nada
if (!dataNascimentoInput) {
    mensagemErro.textContent = 'Por favor, preencha a data de nascimento primeiro.';
    mensagemErro.style.display = 'block';
    this.value = ''; // Limpa a data de admissão
    return;
}

const dataNascimento = new Date(dataNascimentoInput);
const dataAdmissao = new Date(dataAdmissaoInput);
const dataAtual = new Date();
// Calcula a data mínima para admissão (17 anos depois da data de nascimento)
const dataMinimaAdmissao = new Date(dataNascimento);
dataMinimaAdmissao.setFullYear(dataNascimento.getFullYear() + 17);

if (dataAdmissao < dataMinimaAdmissao) {
    mensagemErro.textContent = 'A data de admissão deve ser ao menos 17 anos após a data de nascimento.';
    mensagemErro.style.display = 'block';
    this.value = ''; // Limpa a data inválida
}else if (dataAdmissao > dataAtual) {
    mensagemErro.textContent = 'A data de admissão inválida.';
    mensagemErro.style.display = 'block';
    this.value = '';
} else {
    mensagemErro.style.display = 'none';
}
});

</script>


@endsection
