@extends('Dashboard.layout')
@section('conteudo')


<div class="pcoded-content">
    <!-- [ breadcrumb ] start -->
    <div class="page-header">
        <div class="page-block">
            <div class="row align-items-center">
                <div class="col-md-12">
                    <div class="page-header-title">
                        <h5 class="m-b-10">Pagamento</h5>
                    </div>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html"><i class="feather icon-home"></i></a></li>
                        <li class="breadcrumb-item"><a href="#!">Pagamento</a></li>
                        <li class="breadcrumb-item"><a href="#!">Listagem</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="row">

        <div class="col-xl-12">

            @if($errors->any())

                <div class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                    <span class="badge badge-pill badge-danger">Erro</span>
                    <ul class="errors">
                        @foreach($errors->all() as $erro)
                            <li> {{ $erro }}</li>
                        @endforeach
                    </ul>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
        @endif

            @if(session()->has('sms'))
                <div class="sufee-alert alert with-close alert-success alert-dismissible fade show">
                    <span class="badge badge-pill badge-success">Successo</span>
                    {{ session()->get('sms') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            @endif


            <div class="card">
                <div class="card-header">
                    <h5>Listagem</h5><br>

               </div>
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Criança</th>
                                    <th>Cédula</th>
                                    <th>Mês Pago</th>
                                    <th>Valor Pago</th>
                                    <th>Ano Lectivo</th>
                                    <th>Comprovativo</th>
                                    <th>Data do Pagamento</th>


                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($pagamento as $pagamento)

                                    <tr>

                                        <td> {{$pagamento->nome_completo}}</td>

                                        <td>{{$pagamento->bi_cedula}} </td>
                                        <td>
                                            {{$pagamento->mes_pago}}
                                        </td>
                                        <td>{{$pagamento->valor_pago}} </td>
                                        <td>{{$pagamento->ano_lectivo}} </td>
                                        <td style="text-align: center; size:100px">
                                            @if($pagamento->comprovativo != 'null')
                                                <button  onclick="ver_comprovativo({{ json_encode($pagamento->comprovativo) }})"    data-toggle="modal" data-target="#ver_cartao"  class="btn btn-sm btn-secondary"><i style="color:red" class="fa fa-file"></i></button>
                                            @endif
                                        </td>
                                        <td > {{$pagamento->created_at}}</td>

                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>

</div>


<div id="editar_turma" class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title h4" id="myLargeModalLabel">Editar Dados do Transporte</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>

            <div class="modal-body">


                <div class="modal-body">
                    <form id="formulario_editar" action="{{route('editar.trasnporte')}}" method="post" enctype="multipart/form-data" >
                       @csrf
                       <div class="form-row">

                        <div class="form-group col-md-6">
                            <label for="inputCity">Marca <span style="color: red">*</span></label>
                            <input type="text" id="marca" name="marca" class="form-control" >
                            <input type="text" id="id" name="id" hidden class="form-control" >

                        </div>
                        <div class="form-group col-md-6">
                            <label for="inputCity">Modelo <span style="color: red">*</span></label>
                            <input type="text"  id="modelo" name="modelo" class="form-control" >

                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-4">
                            <label for="inputZip">Matrícula <span style="color: red">*</span></label>
                            <input    type="text" id="matricula" name="matricula" class="form-control" >
                        </div>
                        <div class="form-group col-md-4">
                            <label for="inputZip">Cor <span style="color: red">*</span></label>
                            <input  id="cor" name="cor" class="form-control" >
                        </div>
                        <div class="form-group col-md-4">
                            <label for="inputZip">Capacidade <span style="color: red">*</span></label>
                            <input type="number" min="1" id="capacidade" name="capacidade" class="form-control" >
                        </div>

                    </div>

                        <div class="modal-footer">
                            <button type="button" class="btn  btn-secondary" data-dismiss="modal">Fechar</button>
                            <button onclick="verificarRegisto()"  class="btn  btn-primary">Confirmar</button>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>
</div>

<div id="Eliminar_director" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLiveLabel">Eliminar Transporte</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body text-center">
                <h6 class="mb-0">Deseja realmente eliminar este Transporte <label class="badge badge-light-warning" id="dir_marca"></label> ?</h6>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn  btn-secondary" data-dismiss="modal">Não</button>
                <form action="{{route('eliminar.transporte')}}" method="post" enctype="multipart/form-data" >
                    @csrf
                    <input type="text" id="id_trasporte" name="id_trasporte" hidden>
                    <button type="submit" class="btn  btn-primary">Sim</button>
                </form>

            </div>
        </div>
    </div>
</div>


<div id="ver_cartao" class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title h4" id="myLargeModalLabel">Comprovativo</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <div class="modal-body" id="comprovativo_doc">

                    <iframe src=""
                        style="width: 100%; height: 500px; border: none;">
                </iframe>

                    <div class="modal-footer">
                        <button type="button" class="btn  btn-secondary" data-dismiss="modal">Fechar</button>
                    </div>

                </div>

            </div>
        </div>
    </div>
</div>


<script>

    function ver_comprovativo(comprovativo){

        const comprovativoPath = `/storage/documentos_pagamento/${comprovativo}`;
        document.getElementById('comprovativo_doc').querySelector('iframe').src = comprovativoPath;

        //$('#ver_cartao').modal('show');
    }


</script>

@endsection
