@extends('Dashboard.layout')
@section('conteudo')


<div class="pcoded-content">
    <!-- [ breadcrumb ] start -->
    <div class="page-header">
        <div class="page-block">
            <div class="row align-items-center">
                <div class="col-md-12">
                    <div class="page-header-title">
                        <h5 class="m-b-10">Rotas</h5>
                    </div>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html"><i class="feather icon-home"></i></a></li>
                        <li class="breadcrumb-item"><a href="#!">Rotas</a></li>
                        <li class="breadcrumb-item"><a href="#!">Listagem</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="row">

        <div class="col-xl-12">

            @if($errors->any())

                <div class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                    <span class="badge badge-pill badge-danger">Erro</span>
                    <ul class="errors">
                        @foreach($errors->all() as $erro)
                            <li> {{ $erro }}</li>
                        @endforeach
                    </ul>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
        @endif

            @if(session()->has('sms'))
                <div class="sufee-alert alert with-close alert-success alert-dismissible fade show">
                    <span class="badge badge-pill badge-success">Successo</span>
                    {{ session()->get('sms') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            @endif


            <div class="card">
                <div class="card-header">
                    <h5>Listagem</h5>
               </div>
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Origem</th>
                                    <th>Destino</th>
                                    <th>Acção</th>

                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($rota as $rota)

                                    <tr>
                                        <td>{{$rota->origem}} </td>
                                        <td>{{$rota->destino}}</td>


                                        <td>
                                            @can('editar_rota')
                                                <a href="" data-toggle="modal" data-target="#editar_turma"

                                                onclick="editar_rota({{$rota->id}}, '{{$rota->origem}}', '{{$rota->destino}}')"
                                                >
                                                    <i class="fa-solid fa-pen-to-square" style="color: blue;"></i>
                                                </a>
                                            @endcan

                                            @can('associar_crianca_a_rota')
                                                <a href="" data-toggle="modal" data-target="#adicionar_crianca"

                                                onclick="editar_sala({{ json_encode($rota->id) }})"
                                                >
                                                <i class="fa-solid fa-child" style="color: green"></i>
                                                </a>
                                            @endcan
                                            @can('associar_motorista_a_rota')
                                                <a href="{{route('rotas.funcionario', $rota->id)}}"                                                 >
                                                    <i class="fa-solid fa-user-ninja" style="color:gray;"></i>
                                                </a>
                                            @endcan
                                           
                                            @can('eliminar_rota')
                                                <a href="" onclick="retornaid_nome({{$rota->id}})"  data-toggle="modal" data-target="#Eliminar_director">
                                                    <i class="fa-solid fa-trash" style="color: red;"></i>
                                                </a>

                                            @endcan


                                        </td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>

</div>


<div id="editar_turma" class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title h4" id="myLargeModalLabel">Editar Dados do Transporte</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>

            <div class="modal-body">
                <div  id="sms_erro" class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                    <span class="badge badge-pill badge-danger">Erro</span>
                   Preencha todos os campos obrigatórios.

                </div>

                <div class="modal-body">
                    <form id="formulario_editar" action="{{route('editar.rota')}}" method="post" enctype="multipart/form-data" >
                       @csrf
                       <div class="form-row">

                        <div class="form-group col-md-6">
                            <label for="inputCity">Origem <span style="color: red">*</span></label>
                            <input type="text" id="origem" name="origem" class="form-control" >
                            <input type="text" id="id_rota" name="id_rota" hidden class="form-control" >

                        </div>
                        <div class="form-group col-md-6">
                            <label for="inputCity">Destino <span style="color: red">*</span></label>
                            <input type="text"  id="destino" name="destino" class="form-control" >

                        </div>
                    </div>

                        <div class="modal-footer">
                            <button type="button" class="btn  btn-secondary" data-dismiss="modal">Fechar</button>
                            <button  class="btn  btn-primary">Confirmar</button>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>
</div>

<div id="Eliminar_director" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLiveLabel">Eliminar Transporte</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body text-center">
                <h6 class="mb-0">Deseja realmente eliminar esta Rota ?</h6>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn  btn-secondary" data-dismiss="modal">Não</button>
                <form action="{{route('eliminar.rota')}}" method="post" enctype="multipart/form-data" >
                    @csrf
                    <input type="text" id="id_rota" name="id_rota" hidden>
                    <button type="submit" class="btn  btn-primary">Sim</button>
                </form>

            </div>
        </div>
    </div>
</div>


<script>
    document.getElementById('sms_erro').style.display = 'none';
    function editar_rota(id, origem,destino){

        document.getElementById("id_rota").value = id;
        document.getElementById("origem").value = origem;
        document.getElementById("destino").value  = destino;
    }




    function buscar_data(){

        var data = document.getElementById('ano_letivo').value;

        const ano =  parseInt(data.split('-')[0], 10);
        var ano_letivo = ano+1;
        document.getElementById('ano_letivo2').value = ano_letivo;

    }


    function adicionar_professor(id) {
        document.getElementById('sms_erro').style.display = 'none';
        document.getElementById('id_turma').value = id;
    }

    function retornaid_nome(id,nome){
        $('#id_rota').val(id);
    }

</script>


@endsection
