@extends('Dashboard.layout')
@section('conteudo')


<div class="pcoded-content">
    <!-- [ breadcrumb ] start -->
    <div class="page-header">
        <div class="page-block">
            <div class="row align-items-center">
                <div class="col-md-12">
                    <div class="page-header-title">
                        <h5 class="m-b-10">Salas</h5>
                    </div>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html"><i class="feather icon-home"></i></a></li>
                        <li class="breadcrumb-item"><a href="#!">Salas</a></li>
                        <li class="breadcrumb-item"><a href="#!">Listagem</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="row">

        <div class="col-xl-12">

            @if($errors->any())
                <div class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                    <span class="badge badge-pill badge-danger">Erro</span>
                    <ul class="errors">
                        @foreach($errors->all() as $erro)
                            <li> {{ $erro }}</li>
                        @endforeach
                    </ul>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
        @endif

            @if(session()->has('sms'))
                <div class="sufee-alert alert with-close alert-success alert-dismissible fade show">
                    <span class="badge badge-pill badge-success">Successo</span>
                    {{ session()->get('sms') }}
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            @endif


            <div class="card">
                <div class="card-header">
                    <h5>Listagem</h5>
               </div>
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Ordem da Sala</th>
                                    <th>Capacidade máxima da Sala</th>
                                    <th>Acção</th>

                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($salas as $sala)

                                    <tr>
                                        <td>Sala nº {{$sala->id}} </td>
                                        <td>{{$sala->capacidade}} Crianças</td>


                                        <td>


                                            @can('editar_funcionario')
                                                <a href="" data-toggle="modal" data-target="#editar_director"

                                                onclick="editar_sala({{ json_encode($sala->id) }},{{ json_encode($sala->capacidade)}})"
                                                >
                                                    <i class="fa-solid fa-pen-to-square" style="color: blue;"></i>
                                                </a>
                                            @endcan



                                        </td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <!-- [ Main Content ] end -->
</div>







<!-- editar director -->

<div id="editar_director" class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title h4" id="myLargeModalLabel">Actualizar Capacidade da Sala</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">

                <div class="modal-body">
                    <form id="formulario_editar" action="{{route('editar.sala')}}" method="post" enctype="multipart/form-data" >
                       @csrf


                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="recipient-name" class="col-form-label">Ordem da Sala:</label>
                                    <input type="text" id="id_ordem" name="id_ordem" class="form-control" readonly >
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="recipient-name" class="col-form-label">Capacidade:</label>
                                    <input type="text" id="capacidade" name="capacidade" class="form-control" >
                                </div>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn  btn-secondary" data-dismiss="modal">Fechar</button>
                            <button onclick="verificarRegisto()"  class="btn  btn-primary">Confirmar</button>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>
</div>



<script>

    function editar_sala(id, capacidade){

        document.getElementById("id_ordem").value = id;
        document.getElementById("capacidade").value = capacidade;

    }






</script>


@endsection
