@extends('Dashboard.layout')
@section('conteudo')

<div class="pcoded-content">

    <div class="page-header">
        <div class="page-block">
            <div class="row align-items-center">
                <div class="col-md-12">
                    <div class="page-header-title">
                        <h5 class="m-b-10">Crianças</h5>
                    </div>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html"><i class="feather icon-home"></i></a></li>
                        <li class="breadcrumb-item"><a href="#!">Crianças</a></li>
                        <li class="breadcrumb-item"><a href="#!">Nova</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="row">

        <div class="col-sm-12"  >
            @if($errors->any())
                <div class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                    <span class="badge badge-pill badge-danger">Erro</span>
                    <ul class="errors">
                        @foreach($errors->all() as $erro)
                            <li> {{ $erro }}</li>
                        @endforeach
                    </ul>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            @endif
            <div  id="sms_erro" class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                <span class="badge badge-pill badge-danger">Erro</span>
               Preencha todos os campos obrigatórios.

            </div>
            <div  id="sms_erro2" class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                <span class="badge badge-pill badge-danger">Erro</span>
               As senhas não conicidem.

            </div>

            <div  id="sms_erro4" class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                <span class="badge badge-pill badge-danger">Erro</span>
               Número de Telefone inválido.

            </div>
            <div  id="sms_erro5" class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                <span class="badge badge-pill badge-danger">Erro</span>
               Número de identificação já associado.

            </div>
            <div class="card">
                <div class="card-body">
                    <h5>Novo</h5>
                    <hr>
                    <form id="formulario" action="{{route('inscrever')}}" method="post" enctype="multipart/form-data">
                        @csrf
                        <h6 style="color: black">Informaçoes Pessoais</h6>

                        <div class="form-row">

                            <div class="form-group col-md-3">
                                <label for="inputCity">Nome Completo <span style="color: red">*</span> </label>
                                <input type="text" id="nome" name="nome" class="form-control">

                            </div>

                            <div class="form-group col-md-3">
                                <label for="inputZip">Data de Nascimento <span style="color: red">*</span></label>
                                <input type="date" id="data_nascimento" max="{{date('Y-m-d')}}"  name="data_nascimento" class="form-control" >
                                <small id="data_nascimento_erro" style="color: red; display: none;"></small>

                            </div>
                            <div class="form-group col-md-3">
                                <label for="inputZip">Cédula  <span style="color: red">*</span></label>
                                <input type="text" id="cedula" name="cedula" class="form-control" value="CI-" maxlength="13" required>
                                <small id="cedula-error" style="color: red; display: none;">Formato inválido! O formato deve ser 'CI-XXXXXXX/XX'.</small>

                            </div>
                            <div class="form-group col-md-3">
                                <label for="inputState">Gênero <span style="color: red">*</span></label>
                                <select id="genero" name="genero" class="form-control">
                                    <option value="" >seleccione o gênero</option>
                                    <option value="M">Masculino</option>
                                    <option value="F">Feminino</option>
                                </select>
                            </div>
                        </div>
                        <h6 style="color: black">Informaçoes dos Responsaveis</h6>

                        <div class="form-row">

                            <div class="form-group col-md-3">
                                <label for="inputCity">Nome <span style="color: red">*</span> </label>
                                <input type="text" id="nome_responsavel" name="nome_responsavel" class="form-control">

                            </div>

                            <div class="form-group col-md-3">
                                <label for="inputZip">Contacto <span style="color: red">*</span></label>
                                <input type="text" id="telefone" name="telefone" class="form-control" >
                            </div>
                            <div class="form-group col-md-3">
                                <label for="inputZip">Endereço <span style="color: red">*</span></label>
                                <input type="text" id="endereco" name="endereco" class="form-control" >
                            </div>
                            <div class="form-group col-md-3">
                                <label for="inputState">Relação <span style="color: red">*</span></label>
                                <select id="relacao" name="relacao" class="form-control">
                                    <option value="" >seleccione o grau parentesco</option>
                                    <option value="Pai">Pai</option>
                                    <option value="Mãe">Mãe</option>
                                    <option value="Irmão">Irmão</option>
                                    <option value="Irmã">Irmã</option>
                                    <option value="Outro">Outro</option>
                                </select>
                            </div>
                        </div>
                        <h6 style="color: black">Documentos</h6>
                        <div class="form-row">
                            <div class="form-group col-md-4">
                                <label for="inputCity">Certidão de Nascimento </label>
                                <input type="file" id="certidao" name="certidao" class="form-control" accept=".doc, .docx, .pdf">

                            </div>
                            <div class="form-group col-md-4">
                                <label for="inputCity">Cartão de Vacina</label>
                                <input type="file" id="cartao_vacina" name="cartao_vacina" class="form-control" accept=".doc, .docx, .pdf">

                            </div>
                            <div class="form-group col-md-4">
                                <label for="inputCity">Imagem</label>
                                <input type="file" id="imagem" name="imagem" class="form-control" accept="image/*">

                            </div>
                        </div>

                        <button onclick="verificarRegisto()" class="btn  btn-primary float-right">Inscrever</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <input type="text" id="crianca_reg"  hidden value="{{$crianca}}" >

</div>



<script>
    document.getElementById('sms_erro').style.display = 'none';
    document.getElementById('sms_erro2').style.display = 'none';
    document.getElementById('sms_erro4').style.display = 'none';
    document.getElementById('sms_erro5').style.display = 'none';

    function verificarRegisto(){
        event.preventDefault();

        var nome_completo = document.getElementById('nome').value;
        var genero = document.getElementById('genero').value;
        var telefone = document.getElementById('telefone').value;
        var cedula = document.getElementById('cedula').value;
        var data_nascimento = document.getElementById('data_nascimento').value;
        var nome_responsavel = document.getElementById('nome_responsavel').value;
        var endereco = document.getElementById('endereco').value;
        var relacao = document.getElementById('relacao').value;


        if(cedula ==='' || cedula ==='CI-/' ||  cedula ==='CI-'|| nome_completo ==='' || endereco ==='' || relacao ==='' || data_nascimento ==='' || genero ==='' || nome_responsavel ==='' || telefone ===''){
            document.getElementById('sms_erro').style.display = 'block';
        }else{
            document.getElementById('sms_erro').style.display = 'none';

            if(verificarTelefone(telefone)=== false){
                document.getElementById('sms_erro4').style.display = 'block';
            }else if(verificar_cedula_registado(cedula)===true){
                document.getElementById('sms_erro5').style.display = 'block';
            }else{
                document.getElementById('sms_erro5').style.display = 'none';
                document.getElementById('sms_erro4').style.display = 'none';
                document.getElementById('formulario').submit();
            }
        }
    }

    function verificarTelefone(telefone) {

        const padrao = /^(9)[0-9]{8}$/;

        if (padrao.test(telefone)) {

            return true;
        }

        return false;
    }

    function verificarCedula(bi) {
        const padrao = /^CI-\d{7}\/\d{2}$/;
        bi = bi.toUpperCase();

        if (bi.length === 14) {
            if (padrao.test(bi)) {

            return true;
            }

        }

    return false;
    }


    function verificar_cedula_registado(bi){
        const func_reg = JSON.parse(document.getElementById('crianca_reg').value);

        for(let i = 0; i < func_reg.length; i++){

            if(bi === func_reg[i].bi_cedula){
                return true;
            }

        }
        return false;
    }


    const cedulaInput = document.getElementById('cedula');
  const errorMessage = document.getElementById('cedula-error');

  // Função para formatar o número da cédula enquanto o usuário digita
  cedulaInput.addEventListener('input', function () {
    // Remove qualquer caractere não numérico (exceto a barra "/")
    const value = cedulaInput.value.replace(/[^0-9]/g, '');

    // Limita a quantidade de caracteres para 7 números e 2 após a barra
    const formattedValue = `CI-${value.slice(0, 7)}/${value.slice(7, 9)}`;

    cedulaInput.value = formattedValue;

    // Exibe erro se o valor não estiver completo
    if (!/^CI-\d{7}\/\d{2}$/.test(formattedValue)) {
      errorMessage.style.display = 'block';
    } else {
      errorMessage.style.display = 'none';
    }
  });





  document.getElementById('data_nascimento').addEventListener('input', function() {

if (this.value.split("-")[0] < 1000) {
    return;
}

const dataNascimento = new Date(this.value);
    const dataAtual = new Date();

    // Calcular limites de idade
    const dataMinima = new Date();
    dataMinima.setFullYear(dataAtual.getFullYear() - 6);

    const dataMaxima = new Date();
    dataMaxima.setFullYear(dataAtual.getFullYear() - 3);

    const mensagemErro = document.getElementById('data_nascimento_erro');

    // Verifica se a data é válida
    if (isNaN(dataNascimento.getTime())) {
        mensagemErro.textContent = 'Data inválida. Por favor, insira uma data válida.';
        mensagemErro.style.display = 'block';
        this.value = '';
        return;
    }

    if (dataNascimento < dataMinima) {
        mensagemErro.textContent = 'A idade máxima permitida é de 6 anos.';
        mensagemErro.style.display = 'block';
        this.value = '';
    } else if (dataNascimento > dataMaxima) {
        mensagemErro.textContent = 'A idade mínima permitida é de 3 anos.';
        mensagemErro.style.display = 'block';
        this.value = '';
    } else {
        mensagemErro.style.display = 'none';
    }
});

</script>


@endsection
