@extends('Dashboard.layout')
@section('conteudo')

<div class="pcoded-content">

    <div class="page-header">
        <div class="page-block">
            <div class="row align-items-center">
                <div class="col-md-12">
                    <div class="page-header-title">
                        <h5 class="m-b-10">Directores</h5>
                    </div>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html"><i class="feather icon-home"></i></a></li>
                        <li class="breadcrumb-item"><a href="#!">Directores</a></li>
                        <li class="breadcrumb-item"><a href="#!">Novo</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="row">

        <div class="col-sm-12"  >
            @if($errors->any())
                <div class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                    <span class="badge badge-pill badge-danger">Erro</span>
                    <ul class="errors">
                        @foreach($errors->all() as $erro)
                            <li> {{ $erro }}</li>
                        @endforeach
                    </ul>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
        @endif
            <div  id="sms_erro" class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                <span class="badge badge-pill badge-danger">Erro</span>
               Preencha todos os campos obrigatórios.

            </div>
            <div  id="sms_erro2" class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                <span class="badge badge-pill badge-danger">Erro</span>
               As senhas não conicidem.

            </div>
            <div  id="sms_erro3" class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                <span class="badge badge-pill badge-danger">Erro</span>
               Número de BI inválido.

            </div>
            <div  id="sms_erro4" class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                <span class="badge badge-pill badge-danger">Erro</span>
               Número de Telefone inválido.

            </div>
            <div  id="sms_erro5" class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                <span class="badge badge-pill badge-danger">Erro</span>
               O número de BI informado já se encontra associado.

            </div>
            <div  id="sms_erro6" class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                <span class="badge badge-pill badge-danger">Erro</span>
               O Email informado já se encontra associado.

            </div>
            <div class="card">
                <div class="card-body">
                    <h5>Novo</h5>
                    <p>O cadastro de um novo director destituirá automaticamente o dirrector actual</p>
                    <hr>
                    <form id="formulario" action="{{route('redistar.director.post')}}" method="post" enctype="multipart/form-data">
                        @csrf
                        <h6 style="color: black">Dados do Novo Director</h6>

                        <div class="form-row">

                            <div class="form-group col-md-4">
                                <label for="inputCity">Nome Completo <span style="color: red">*</span> </label>
                                <input type="text" id="nome" name="nome" class="form-control">

                            </div>

                            <div class="form-group col-md-4">
                                <label for="inputZip">BI <span style="color: red">*</span></label>
                                <input type="text" id="bi" name="bi" class="form-control" >
                                <small id="bi-error" style="color: red; display: none;">Número do BI inválido'.</small>

                            </div>
                            <div class="form-group col-md-4">
                                <label for="inputState">Gênero <span style="color: red">*</span></label>
                                <select id="genero" name="genero" class="form-control">
                                    <option value="" >seleccione o gênero</option>
                                    <option value="M">Masculino</option>
                                    <option value="F">Feminino</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-4">
                                <label for="inputCity">Data de Nascimeto </label>
                                <input type="date" max="{{date('Y-m-d')}}"  id="data_nascimento" name="data_nascimento" class="form-control" >
                                <small id="data_nascimento_erro" style="color: red; display: none;"></small>
                            </div>
                            <div class="form-group col-md-4">
                                <label for="inputZip">Data de Admissão</label>
                                <input type="date" id="data_admissao" max="{{date('Y-m-d')}}"  name="data_admissao" class="form-control" >
                                <small id="data_admissao_erro" style="color: red; display: none;"></small>
                            </div>

                            <div class="form-group col-md-4">
                                <label for="inputZip">Foto</label>
                                <input type="file" id="foto" name="foto" class="form-control" >
                            </div>
                        </div>

                        <h6 style="color: black">Contacto</h6>
                        <div class="form-row">
                            <div class="form-group col-md-4">
                                <label for="inputCity">Telefone <span style="color: red">*</span></label>
                                <input type="text" id="telefone" name="telefone" class="form-control">
                            </div>
                            <div class="form-group col-md-4">
                                <label for="inputCity">Cidade</label>
                                <input type="text" id="cidade" name="cidade" class="form-control" >
                            </div>
                            <div class="form-group col-md-4">
                                <label for="inputCity">Endereço</label>
                                <input type="text" id="endereco" name="endereco" class="form-control" >
                            </div>
                        </div>
                        <div >
                            <hr>
                            <h6 style="color: black">Dados de Utilizador</h6>
                            <div class="form-row">
                                <div class="form-group col-md-6">
                                    <label for="inputCity">Nome de Utilizador <span style="color: red">*</span></label>
                                    <input type="text" id="nome_utilizador" name="nome_utilizador" class="form-control" >
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="inputCity">Email <span style="color: red">*</span></label>
                                    <input type="text" id="email" name="email" class="form-control">
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="inputCity">Palavra Passe <span style="color: red">*</span></label>
                                    <input type="text" id="palavra_passe" name="palavra_passe" class="form-control">
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="inputCity">Confirmar Palavra Passe <span style="color: red">*</span></label>
                                    <input type="text" id="palavra_passe2" name="palavra_passe2" class="form-control" >
                                </div>
                            </div>
                        </div>



                        <button onclick="verificarRegisto()" class="btn  btn-primary float-right">Registar</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <input type="text" id="funcionario_reg"  hidden value="{{$funcionario}}" >
</div>


<script>

    document.getElementById('sms_erro').style.display = 'none';
    document.getElementById('sms_erro2').style.display = 'none';
    document.getElementById('sms_erro3').style.display = 'none';
    document.getElementById('sms_erro4').style.display = 'none';
    document.getElementById('sms_erro5').style.display = 'none';
    document.getElementById('sms_erro6').style.display = 'none';



function verificarRegisto(){
    event.preventDefault();

    var nome_completo = document.getElementById('nome').value;
    var bi = document.getElementById('bi').value;
    var genero = document.getElementById('genero').value;
    var telefone = document.getElementById('telefone').value;
    var nome_uti = document.getElementById('nome_utilizador').value;
    var email = document.getElementById('email').value;
    var senha1 = document.getElementById('palavra_passe').value;
    var senha2 = document.getElementById('palavra_passe2').value;


    if(nome_completo ==='' || bi ==='' || genero ==='' || telefone ==='' || nome_uti ==='' || email ==='' || senha1 ==='' || senha2 ===''){
        document.getElementById('sms_erro').style.display = 'block';
    }else{
        document.getElementById('sms_erro').style.display = 'none';


        if(verificarBI(bi)=== false){
            document.getElementById('sms_erro3').style.display = 'block';
        }else{
            document.getElementById('sms_erro3').style.display = 'none';
        }

        if(verificarTelefone(telefone)=== false){
            document.getElementById('sms_erro4').style.display = 'block';
        }else{
            document.getElementById('sms_erro4').style.display = 'none';
        }

        if(verificar_bi_registado(bi) === true){

            document.getElementById('sms_erro5').style.display = 'block';
        }else{
            document.getElementById('sms_erro5').style.display = 'none';
        }

        if(verificar_email_registado(email)===true){

            document.getElementById('sms_erro6').style.display = 'block';
        }else{
            document.getElementById('sms_erro6').style.display = 'none';
        }

        if(verificarsenha(senha1, senha2)===false){

            document.getElementById('sms_erro2').style.display = 'block';
        }else{
            document.getElementById('sms_erro2').style.display = 'none';
        }

        if(verificar_email_registado(email)===false && verificar_bi_registado(bi) === false && verificarsenha(senha1, senha2)==true && verificarBI(bi)===true && verificarTelefone(telefone)===true){
            document.getElementById('formulario').submit();
        }

    }
}

function verificarBI(bi) {

   const padrao = /^[0-9]{9}(BO|BA|BE|CA|CC|KN|KS|CE|HO|HA|LA|LN|LS|ME|MO|NA|UE|ZA)[0-9]{3}$/;
   bi = bi.toUpperCase();

  if (bi.length === 14) {
     if (padrao.test(bi)) {

       return true;
     }

   }

   return false;
}

function verificarTelefone(telefone) {

const padrao = /^(9)[0-9]{8}$/;

  if (padrao.test(telefone)) {

    return true;
}

return false;
}

function verificarsenha(s1, s2) {

  if (s1 === s2 && s1 !='') {

    return true;
}

return false;
}


function verificar_bi_registado(bi){
    const func_reg = JSON.parse(document.getElementById('funcionario_reg').value);

    for(let i = 0; i < func_reg.length; i++){

        if(bi === func_reg[i].bi_cedula){
            return true;
        }

    }
    return false;
}

    function verificar_email_registado(email){
        const func_reg = JSON.parse(document.getElementById('funcionario_reg').value);

        for(let i = 0; i < func_reg.length; i++){

            if(email === func_reg[i].email){
                return true;
            }

        }
        return false;
    }


    document.getElementById('bi').addEventListener('input', function (event) {
    let value = event.target.value.toUpperCase(); // Converter para maiúsculas para letras
    let formattedValue = '';

    for (let i = 0; i < value.length; i++) {
      if (i < 9) {
        // Permite apenas números nas primeiras 9 posições
        if (/[0-9]/.test(value[i])) {
          formattedValue += value[i];
        }
      } else if (i >= 9 && i < 11) {
        // Permite apenas letras maiúsculas entre a 10ª e 11ª posição
        if (/[A-Z]/.test(value[i])) {
          formattedValue += value[i];
        }
      } else if (i >= 11 && i < 14) {
        // Permite apenas números entre a 12ª e 14ª posição
        if (/[0-9]/.test(value[i])) {
          formattedValue += value[i];
        }
      }
    }

    // Atualiza o campo com o valor formatado (sem apagar valores corretos)
    event.target.value = formattedValue;

    // Validação final
    if (/^[0-9]{9}(BO|BA|BE|CA|CC|KN|KS|CE|HO|HA|LA|LN|LS|ME|MO|NA|UE|ZA)[0-9]{3}$/.test(formattedValue)) {
      document.getElementById('bi-error').style.display = 'none';
    } else {
      document.getElementById('bi-error').style.display = 'block';
    }
  });





    document.getElementById('data_nascimento').addEventListener('input', function() {

        if (this.value.split("-")[0] < 1000) {
            return;
        }

        const dataNascimento = new Date(this.value);
            const dataAtual = new Date();

            // Calcular limites de idade
            const dataMinima = new Date();
            dataMinima.setFullYear(dataAtual.getFullYear() - 70); // 70 anos atrás

            const dataMaxima = new Date();
            dataMaxima.setFullYear(dataAtual.getFullYear() - 30); // 17 anos atrás

            const mensagemErro = document.getElementById('data_nascimento_erro');

            // Verifica se a data é válida
            if (isNaN(dataNascimento.getTime())) {
                mensagemErro.textContent = 'Data inválida. Por favor, insira uma data válida.';
                mensagemErro.style.display = 'block';
                this.value = '';
                return;
            }

            if (dataNascimento < dataMinima) {
                mensagemErro.textContent = 'A idade máxima permitida é de 70 anos.';
                mensagemErro.style.display = 'block';
                this.value = '';
            } else if (dataNascimento > dataMaxima) {
                mensagemErro.textContent = 'A idade mínima permitida é de 30 anos.';
                mensagemErro.style.display = 'block';
                this.value = '';
            } else {
                mensagemErro.style.display = 'none';
            }
    });


    document.getElementById('data_admissao').addEventListener('change', function() {
        const dataNascimentoInput = document.getElementById('data_nascimento').value;
        const dataAdmissaoInput = this.value;
        const mensagemErro = document.getElementById('data_admissao_erro');
        if (this.value.split("-")[0] < 1000) {
            return;
        }


        // Se a data de nascimento não foi preenchida, não faz nada
        if (!dataNascimentoInput) {
            mensagemErro.textContent = 'Por favor, preencha a data de nascimento primeiro.';
            mensagemErro.style.display = 'block';
            this.value = ''; // Limpa a data de admissão
            return;
        }

        const dataNascimento = new Date(dataNascimentoInput);
        const dataAdmissao = new Date(dataAdmissaoInput);
        const dataAtual = new Date();
        // Calcula a data mínima para admissão (17 anos depois da data de nascimento)
        const dataMinimaAdmissao = new Date(dataNascimento);
        dataMinimaAdmissao.setFullYear(dataNascimento.getFullYear() + 17);

        if (dataAdmissao < dataMinimaAdmissao) {
            mensagemErro.textContent = 'A data de admissão deve ser ao menos 17 anos após a data de nascimento.';
            mensagemErro.style.display = 'block';
            this.value = ''; // Limpa a data inválida
        }else if (dataAdmissao > dataAtual) {
            mensagemErro.textContent = 'A data de admissão inválida.';
            mensagemErro.style.display = 'block';
            this.value = '';
        } else {
            mensagemErro.style.display = 'none';
        }
    });
</script>


@endsection
