
<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>Creche</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />



        <link rel="icon" href="assets/images/avatar_homem.png" type="image/x-icon">


	<link rel="stylesheet" href="{{asset('assets/css/style.css')}} ">
    </head>

    <body>
        <div class="auth-wrapper">

            <div class="auth-content text-center">

                <!--<img src="assets/images/logo.png" alt="" class="img-fluid mb-4">-->
                <h3 style="color: white">Creche</h3>

                <div class="card borderless">
                    <div class="row align-items-center ">
                        <div class="col-md-12">
                            <div class="card-body">
                                <h4 class="mb-3 f-w-400">Login</h4>
                                <hr>

                                <x-input-error :messages="$errors->get('email')" class="mt-2" style="color: red;" />

                                <form  method="POST" action="{{ route('login') }}">
                                    @csrf
                                    <div class="form-group mb-3">

                                        <x-text-input id="email" class="form-control" type="email" name="email" :value="old('email')" required autofocus autocomplete="username" placeholder="Email"/>
                                    </div>

                                    <div class="form-group mb-4">

                                        <x-text-input id="password" class="form-control"
                                                    type="password"
                                                    name="password"
                                                    required autocomplete="current-password"  placeholder="Palavra passe"/>


                                    </div>


                                    <x-primary-button class="btn btn-block btn-primary mb-4">
                                        {{ __('Entrar') }}
                                    </x-primary-button>
                                    <hr>



                                    <p class="mb-2 text-muted"><a href="" class="f-w-400">Esqueceu sua senha ? </a></p>

                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <script src="{{asset('assets/js/vendor-all.min.js')}}"></script>
        <script src="{{asset('assets/js/plugins/bootstrap.min.js')}}"></script>

    </body>
</html>



