<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\Auth\AuthenticatedSessionController;
use App\Http\Controllers\FuncionarioController;
use App\Http\Controllers\SalaController;
use App\Http\Controllers\TransporteController;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\CriancaController;
use App\Http\Controllers\PagamentoController;

Route::get('/', function () {
    if(!Auth::check() == true) {
        return view('auth.login');
    }
    return redirect()->route('home');
});

Route::middleware('auth', 'verified')->group(function () {

    Route::get('home', [HomeController::class, 'home'])->name('home');
    Route::get('logout', [AuthenticatedSessionController::class, 'destroy'])->name('logout');

    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    Route::get('director/novo', [FuncionarioController::class, 'registar_director'])->name('redistar.director');
    Route::post('director/post', [FuncionarioController::class, 'registar_director_store'])->name('redistar.director.post');
    Route::get('director/listagem', [FuncionarioController::class, 'listar_director'])->name('listar.director');
    Route::post('director/delet', [FuncionarioController::class, 'eliminar_director'])->name('eliminar.director');
    Route::post('director/edit', [FuncionarioController::class, 'editar_director'])->name('editar.director');


    Route::get('funcionario/novo', [FuncionarioController::class, 'registar'])->name('registar_funcionario');
    Route::post('funcionario/post', [FuncionarioController::class, 'registar_post'])->name('registar.funcionario.post');
    Route::get('professor/listagem', [FuncionarioController::class, 'listar_professor'])->name('listar.professor');
    Route::get('secretario/listagem', [FuncionarioController::class, 'listar_secretario'])->name('listar.secretario');
    Route::get('motorista/listagem', [FuncionarioController::class, 'listar_motorista'])->name('listar.motorista');
    Route::get('funcionario/listagem', [FuncionarioController::class, 'listar'])->name('listar.funcionario');



    Route::post('funcionario/delet', [FuncionarioController::class, 'eliminar_funcionario'])->name('eliminar.funcionario');
    Route::post('funcionario/edit', [FuncionarioController::class, 'editar_funcionario'])->name('editar.funcionario');

    Route::get('salas/nova', [SalaController::class, 'nova_sala'])->name('salas');
    Route::post('sala/post', [SalaController::class, 'registar_sala_post'])->name('redistar.sala.post');
    Route::get('salas/listagem', [SalaController::class, 'listar_salas'])->name('listar.salas');
    Route::post('sala/edit', [SalaController::class, 'editar_sala'])->name('editar.sala');
    Route::get('turmas/nova',[SalaController::class, 'Nova_turma'])->name('turmas');
    Route::post('turma/post', [SalaController::class, 'registar_turma_post'])->name('registar.turma.post');
    Route::get('Turmas/listagem', [SalaController::class, 'listar_turmas'])->name('listar.turmas');
    Route::post('turma/edit', [SalaController::class, 'editar_turma'])->name('editar.turma');
    Route::post('adicionar_cuidadora', [SalaController::class, 'adicionar_cuidadora'])->name('adicionar.professor');
    Route::get('criancas/turma/{id_turma}',[SalaController::class, 'adicionar_crianca'])->name('adicionar.crianca.turma');

    Route::get('transportes/novo',[TransporteController::class, 'novo_transporte'])->name('transporte.novo');
    Route::get('transportes/listagem',[TransporteController::class, 'listar_transporte'])->name('transporte.listar');
    Route::post('transporte/post', [TransporteController::class, 'post_transporte'])->name('registar.trasnporte.post');
    Route::post('eliminar/transporte', [TransporteController::class, 'eliminar_transporte'])->name('eliminar.transporte');
    Route::post('editar/transporte', [TransporteController::class, 'editar_trasnporte'])->name('editar.trasnporte');
    Route::get('rotas/novo',[TransporteController::class, 'nova_rota'])->name('rota.novo');
    Route::get('rotas/listagem',[TransporteController::class, 'listar_rota'])->name('rota.listar');
    Route::post('rota/post', [TransporteController::class, 'post_rota'])->name('registar.rota.post');
    Route::post('rota/eliminar', [TransporteController::class, 'eliminar_rota'])->name('eliminar.rota');
    Route::post('rota/editar', [TransporteController::class, 'editar_rota'])->name('editar.rota');

    Route::get('rotas/funcionario/{id}',[TransporteController::class, 'rota_funcionario'])->name('rotas.funcionario');
    Route::post('rota/func', [TransporteController::class, 'associar_rota_func'])->name('registar.rota.func');
    Route::post('eliminar/rota/func', [TransporteController::class, 'desassociar_rota_func'])->name('eliminar.rota.func');
    Route::get('criancas/nova',[CriancaController::class, 'nova_crianca'])->name('nova.crianca');
    Route::get('criancas/listagem',[CriancaController::class, 'listar_crianca'])->name('listar.crianca');
    Route::post('criancas/inscrever',[CriancaController::class, 'increverPost'])->name('inscrever');
    Route::get('crianca/perfil/{id}',[CriancaController::class, 'perfil_crianca'])->name('perfil.crianca');
    Route::post('criancas/editar',[CriancaController::class, 'editar_post'])->name('editar.crianca');
    Route::get('criancas/matricula',[CriancaController::class, 'matricula'])->name('crianca.matricula');
    Route::post('criancas/matricula/post',[CriancaController::class, 'matricular_post'])->name('crianca.matricular');
    Route::post('criancas/transferir',[CriancaController::class, 'transferir'])->name('transferir');
    Route::get('ano_lectivo',[CriancaController::class, 'ano_letivo'])->name('ano.letivo');
    Route::post('ano_lectivo/post',[CriancaController::class, 'ano_letivo_post'])->name('ano_letivo.post');

    Route::get('pagamento/novo',[PagamentoController::class, 'pagamento'])->name('novo.pagamento');
    Route::post('pagar/post',[PagamentoController::class, 'pagamento_post'])->name('pagar');
    Route::get('pagamento/listagem',[PagamentoController::class, 'pagamento_listagem'])->name('lista.pagamento');
    Route::get('pagamento/contas_a_receber',[PagamentoController::class, 'pagamento_divida'])->name('lista.dividas');



});


require __DIR__.'/auth.php';
