<?php $__env->startSection('conteudo'); ?>


<div class="pcoded-content">
    <!-- [ breadcrumb ] start -->
    <div class="page-header">
        <div class="page-block">
            <div class="row align-items-center">
                <div class="col-md-12">
                    <div class="page-header-title">
                        <h5 class="m-b-10">Crianças</h5>
                    </div>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html"><i class="feather icon-home"></i></a></li>
                        <li class="breadcrumb-item"><a href="#!">Crianças</a></li>
                        <li class="breadcrumb-item"><a href="#!">Listagem</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="row">

        <div class="col-xl-12">

            <?php if($errors->any()): ?>

                <div class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                    <span class="badge badge-pill badge-danger">Erro</span>
                    <ul class="errors">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $erro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li> <?php echo e($erro); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
        <?php endif; ?>

            <?php if(session()->has('sms')): ?>
                <div class="sufee-alert alert with-close alert-success alert-dismissible fade show">
                    <span class="badge badge-pill badge-success">Successo</span>
                    <?php echo e(session()->get('sms')); ?>

                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            <?php endif; ?>


            <div class="card">
                <div class="card-header">
                    <h5>Listagem</h5><br>
                    <br><label>Total de Crianças: <?php echo e($criancas_total->total_inscritas); ?></label><br>
                    <label>Total Masculino: <?php echo e($criancas_total->total_masculino); ?> </label><br>
                    <label>Total Feminino:  <?php echo e($criancas_total->total_feminino); ?></label>
               </div>
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Foto</th>
                                    <th>Nome</th>
                                    <th>Gênero</th>
                                    <th>Data de Nascimento</th>
                                    <th>Idade</th>
                                    <th>Responsavel</th>
                                    <th>Grau do Responsavel</th>
                                    <th>Contacto</th>
                                    <th>Acção</th>

                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $criancas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crianca): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <tr>

                                        <td class="text-center">
                                            <?php if($crianca->imagem == null): ?>
                                                <?php if($crianca->genero== "M" ): ?>
                                                    <img src="<?php echo e(asset('assets/images/avatar_homem.png')); ?>"
                                                    alt="avatar"
                                                    style="width: 40px; height: 40px;border-radius: 16px">

                                                <?php else: ?>
                                                    <img src="<?php echo e(asset('assets/images/avatar_mulher.jpg')); ?>"
                                                    alt="avatar"
                                                    style="width: 40px; height: 40px;border-radius: 16px">

                                                <?php endif; ?>
                                            <?php else: ?>
                                                <img src="<?php echo e(asset('storage/imagem_crianca/'.$crianca->imagem)); ?>"
                                                alt="avatar"
                                                style="width: 40px; height: 40px;border-radius: 16px">
                                            <?php endif; ?>
                                        </td>

                                        <td><?php echo e($crianca->nome_completo); ?> </td>
                                        <td>
                                            <?php if( $crianca->genero== "M" ): ?>
                                                Masculino
                                            <?php else: ?>
                                                Feminino
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($crianca->data_nascimento); ?> </td>
                                        <td><?php echo e($crianca->idade); ?> </td>
                                        <td><?php echo e($crianca->responsavel1); ?> </td>
                                        <td><?php echo e($crianca->grau); ?> </td>
                                        <td><?php echo e($crianca->contacto); ?> </td>
                                        <td>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ver_detalhes_crianca')): ?>
                                                <a href="<?php echo e(route('perfil.crianca',$crianca->id)); ?>"

                                               >
                                                    <i class="fa-solid fa-eye" style="color: blue;"></i>
                                                </a>
                                            <?php endif; ?>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>

</div>


<div id="editar_turma" class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title h4" id="myLargeModalLabel">Editar Dados do Transporte</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>

            <div class="modal-body">
                <div  id="sms_erro" class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                    <span class="badge badge-pill badge-danger">Erro</span>
                   Preencha todos os campos obrigatórios.

                </div>

                <div class="modal-body">
                    <form id="formulario_editar" action="<?php echo e(route('editar.trasnporte')); ?>" method="post" enctype="multipart/form-data" >
                       <?php echo csrf_field(); ?>
                       <div class="form-row">

                        <div class="form-group col-md-6">
                            <label for="inputCity">Marca <span style="color: red">*</span></label>
                            <input type="text" id="marca" name="marca" class="form-control" >
                            <input type="text" id="id" name="id" hidden class="form-control" >

                        </div>
                        <div class="form-group col-md-6">
                            <label for="inputCity">Modelo <span style="color: red">*</span></label>
                            <input type="text"  id="modelo" name="modelo" class="form-control" >

                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-4">
                            <label for="inputZip">Matrícula <span style="color: red">*</span></label>
                            <input    type="text" id="matricula" name="matricula" class="form-control" >
                        </div>
                        <div class="form-group col-md-4">
                            <label for="inputZip">Cor <span style="color: red">*</span></label>
                            <input  id="cor" name="cor" class="form-control" >
                        </div>
                        <div class="form-group col-md-4">
                            <label for="inputZip">Capacidade <span style="color: red">*</span></label>
                            <input type="number" min="1" id="capacidade" name="capacidade" class="form-control" >
                        </div>

                    </div>

                        <div class="modal-footer">
                            <button type="button" class="btn  btn-secondary" data-dismiss="modal">Fechar</button>
                            <button onclick="verificarRegisto()"  class="btn  btn-primary">Confirmar</button>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>
</div>

<div id="Eliminar_director" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLiveLabel">Eliminar Transporte</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body text-center">
                <h6 class="mb-0">Deseja realmente eliminar este Transporte <label class="badge badge-light-warning" id="dir_marca"></label> ?</h6>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn  btn-secondary" data-dismiss="modal">Não</button>
                <form action="<?php echo e(route('eliminar.transporte')); ?>" method="post" enctype="multipart/form-data" >
                    <?php echo csrf_field(); ?>
                    <input type="text" id="id_trasporte" name="id_trasporte" hidden>
                    <button type="submit" class="btn  btn-primary">Sim</button>
                </form>

            </div>
        </div>
    </div>
</div>


<script>
    document.getElementById('sms_erro').style.display = 'none';
    function editar_transporte(id, marca,modelo,capacidade, matricula, cor){

        document.getElementById("id").value = id;
        document.getElementById("marca").value = marca;
        document.getElementById("modelo").value  = modelo;
        document.getElementById("matricula").value = matricula;
        document.getElementById("cor").value = cor;
        document.getElementById("capacidade").value = capacidade;
    }


    function verificarRegisto(){
        event.preventDefault();
        var marca = document.getElementById("marca").value;
        var modelo = document.getElementById("modelo").value ;
        var  matricula = document.getElementById("matricula").value;
        var cor = document.getElementById("cor").value;
        var capacidade = document.getElementById("capacidade").value;

        if(capacidade == 0 || marca ==="" || modelo==="" || cor === "" || matricula ===""){
            document.getElementById('sms_erro').style.display = 'block';
        }else{
            document.getElementById('sms_erro').style.display = 'none';
            document.getElementById('formulario_editar').submit();
        }
    }

    function buscar_data(){

        var data = document.getElementById('ano_letivo').value;

        const ano =  parseInt(data.split('-')[0], 10);
        var ano_letivo = ano+1;
        document.getElementById('ano_letivo2').value = ano_letivo;

    }


    function adicionar_professor(id) {
        document.getElementById('sms_erro').style.display = 'none';
        document.getElementById('id_turma').value = id;
    }

    function retornaid_nome(id,nome){
        $('#id_trasporte').val(id);
        document.getElementById("dir_marca").innerHTML = nome;
    }

</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('Dashboard.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Ferdinando Roque\Documents\GitHub\creche\resources\views/Dashboard/pagina/listagem_crianca.blade.php ENDPATH**/ ?>