<?php $__env->startSection('conteudo'); ?>


<div class="pcoded-content">
    <!-- [ breadcrumb ] start -->
    <div class="page-header">
        <div class="page-block">
            <div class="row align-items-center">
                <div class="col-md-12">
                    <div class="page-header-title">
                        <h5 class="m-b-10">Matricula</h5>
                    </div>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html"><i class="feather icon-home"></i></a></li>
                        <li class="breadcrumb-item"><a href="#!">Criança</a></li>
                        <li class="breadcrumb-item"><a href="#!">Mariculat</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="row">

        <div class="col-xl-12">

            <?php if($errors->any()): ?>

                    <div class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                        <span class="badge badge-pill badge-danger">Erro</span>
                        <ul class="errors">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $erro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li> <?php echo e($erro); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
            <?php endif; ?>

            <?php if(session()->has('sms')): ?>
                <div class="sufee-alert alert with-close alert-success alert-dismissible fade show">
                    <span class="badge badge-pill badge-success">Successo</span>
                    <?php echo e(session()->get('sms')); ?>

                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
            <?php endif; ?>

            <div class="card">
                <div class="card-body">
                    <h5>Nova Matrícula</h5>

                    <hr>
                    <div  id="sms_erro" class="sufee-alert alert with-close alert-warning alert-dismissible fade show">
                        <span class="badge badge-pill badge-warning">Erro</span>
                       A turma seleccionada atingiu o seu limite, escolha outra truma.

                    </div>
                    <div  id="sms_erro2" class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                        <span class="badge badge-pill badge-danger">Aviso</span>
                       preencha os campos obrigatório.

                    </div>


                    <form id="formulario" action="<?php echo e(route('crianca.matricular')); ?>" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>

                        <div class="form-row">

                            <div class="form-group col-md-12">
                                <label for="inputCity">Buscar Criança <span style="color: red">*</span></label>
                                <select id="crianca" name="crianca" class="form-control">
                                    <option value="" >seleccione a criança</option>
                                    <?php $__currentLoopData = $criancasNaoMatriculadas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($cria->id_crianca); ?>"><?php echo e($cria->nome_completo); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>


                            </div>
                            <div class="form-group col-md-4">
                                <label for="inputCity">Buscar Turma <span style="color: red">*</span></label>
                                <select id="buscar_turma" name="buscar_turma" onchange="buscar_capacidade(this.value)" class="form-control">
                                    <option value="" >seleccione a turma</option>
                                    <?php $__currentLoopData = $turma; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($tur->id); ?>" ><?php echo e($tur->nome); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>

                            </div>
                            <div class="form-group col-md-4">
                                <label for="inputCity">Capacidade <span style="color: red">*</span></label>
                                <input type="text" id="capacidade" readonly class="form-control">

                            </div>
                            <div class="form-group col-md-4">
                                <label for="inputCity">Crianças Matriculadas <span style="color: red">*</span></label>
                                <input type="text" id="matriculadas" readonly class="form-control">

                            </div>

                        </div>


                        <button onclick="verificarRegisto()" id="botao_reg"  class="btn  btn-primary float-right">Confirmar Matrícula</button>
                    </form>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h5>Crianças Matriculadas neste ano lectivo <?php echo e($inicio_fim); ?></h5>
               </div>


                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Foto</th>
                                    <th>Nome</th>
                                    <th>Cédula</th>
                                    <th>Gênero</th>
                                    <th>Data de Nascimento</th>
                                    <th>Turma</th>
                                    <th>Acção</th>

                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $crianca; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <tr>
                                        <td class="text-center">
                                            <?php if($cria->imagem == null): ?>
                                                <?php if($cria->genero== "M" ): ?>
                                                    <img src="<?php echo e(asset('assets/images/avatar_homem.png')); ?>"
                                                    alt="avatar"
                                                    style="width: 40px; height: 40px;border-radius: 16px">

                                                <?php else: ?>
                                                    <img src="<?php echo e(asset('assets/images/avatar_mulher.jpg')); ?>"
                                                    alt="avatar"
                                                    style="width: 40px; height: 40px;border-radius: 16px">

                                                <?php endif; ?>
                                            <?php else: ?>
                                                <img src="<?php echo e(asset('storage/imagem_crianca/'.$cria->imagem)); ?>"
                                                alt="avatar"
                                                style="width: 40px; height: 40px;border-radius: 16px">
                                            <?php endif; ?>
                                        </td>

                                        <td><?php echo e($cria->nome_completo); ?> </td>
                                        <td><?php echo e($cria->bi_cedula); ?> </td>
                                        <td>
                                            <?php if( $cria->genero== "M" ): ?>
                                                Masculino
                                            <?php else: ?>
                                                Feminino
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($cria->data_nascimento); ?> </td>
                                        <td><?php echo e($cria->turma); ?> </td>


                                        <td>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ver_detalhes_crianca')): ?>
                                                <a href="<?php echo e(route('perfil.crianca',$cria->id_pessoa)); ?>"

                                            >
                                                    <i class="fa-solid fa-eye" style="color: blue;"></i>
                                                </a>
                                            <?php endif; ?>
                                            <a href="" data-toggle="modal" data-target="#transferir"
                                                onclick="transferir(<?php echo e(json_encode($cria->id_crianca)); ?>,<?php echo e(json_encode($cria->turma)); ?>,<?php echo e(json_encode($cria->id_turma)); ?>,<?php echo e(json_encode($cria->nome_completo)); ?>)"
                                            >
                                                <i class="fa-solid fa-exchange" style="color:rgb(15, 15, 15);"></i>
                                            </a>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>
 <input type="text " id="turma_reg"  hidden value="<?php echo e($turma); ?>">
</div>




<div id="transferir" class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title h4" id="myLargeModalLabel">Transferência de criança pra outra turma</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>

            <div class="modal-body">

                <div class="modal-body">
                    <form id="transferir" action="<?php echo e(route('transferir')); ?>" method="post" enctype="multipart/form-data" >
                       <?php echo csrf_field(); ?>
                       <h5>Criança: <label id="crianca_nome"></label> </h5>
                       <div class="form-row">

                            <div class="form-group col-md-12">
                                <label for="inputCity">Turma <span style="color: red">*</span></label>
                                <select  onchange="buscar_capacidade()" id="turma" name="turma" class="form-control">
                                    <option value="" id="id_turma" ></option>

                                    <?php $__currentLoopData = $turma; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $turma): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($turma->id); ?>"><?php echo e($turma->nome); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </select>
                                <input type="text" hidden id="id_crianca" name="id_crianca">
                                <input type="text" hidden id="id_turma_actual" name="id_turma_actual">

                            </div>

                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn  btn-secondary" data-dismiss="modal">Fechar</button>
                            <button  class="btn  btn-primary">Confirmar</button>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>
</div>




<script>


    document.getElementById('sms_erro').style.display = 'none';
    document.getElementById('sms_erro2').style.display = 'none';



    function verificarRegisto(){
        event.preventDefault();
        var crianca = document.getElementById("crianca").value;
        var turma = document.getElementById("buscar_turma").value;

        if(crianca === "" || turma==""){
            document.getElementById('sms_erro2').style.display = 'block';
        }else{
            document.getElementById('sms_erro').style.display = 'none';
            document.getElementById('formulario').submit();
        }
    }


    function buscar_capacidade(valor){
        document.getElementById('sms_erro').style.display = 'none';
        var turmas = JSON.parse(document.getElementById('turma_reg').value);
        for(var i = 0; i < turmas.length; i++){
            if(turmas[i].id == valor){
                document.getElementById('capacidade').value = turmas[i].total_criancas;
                document.getElementById('matriculadas').value = turmas[i].total_matriculadas;

                if(turmas[i].total_criancas == turmas[i].total_matriculadas){
                    document.getElementById('sms_erro').style.display = 'block';
                    document.getElementById('botao_reg').disabled = true;
                }
            }
        }
    }

    function transferir(id_crianca,turma,id_turma, nome_aluno){

        document.getElementById("crianca_nome").innerHTML = nome_aluno;
        document.getElementById("id_crianca").value = id_crianca;
        document.getElementById("id_turma_actual").value = id_turma;

        document.getElementById("id_turma").value = id_turma;
        document.getElementById("id_turma").innerHTML  = turma;

    }


</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('Dashboard.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Ferdinando Roque\Documents\GitHub\creche\resources\views/Dashboard/pagina/matricula.blade.php ENDPATH**/ ?>