<?php $__env->startSection('conteudo'); ?>

<div class="pcoded-content">

    <div class="page-header">
        <div class="page-block">
            <div class="row align-items-center">
                <div class="col-md-12">
                    <div class="page-header-title">
                        <h5 class="m-b-10">Criança</h5>
                    </div>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="index.html"><i class="feather icon-home"></i></a></li>
                        <li class="breadcrumb-item"><a href="#!">Criança</a></li>
                        <li class="breadcrumb-item"><a href="#!">Perfil</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <?php if($errors->any()): ?>
    <div class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
        <span class="badge badge-pill badge-danger">Erro</span>
        <ul class="errors">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $erro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li> <?php echo e($erro); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
<?php endif; ?>


<?php if(session()->has('sms')): ?>
    <div class="sufee-alert alert with-close alert-success alert-dismissible fade show">
        <span class="badge badge-pill badge-success">Successo</span>
        <?php echo e(session()->get('sms')); ?>

        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
<?php endif; ?>
    <div class="row">

                <div class="card col-md-4">
                    <br>
                   <?php if($crianca->imagem == null): ?>
                        <?php if($crianca->genero== "M" ): ?>
                            <img class="img-fluid card-img-top"  src="<?php echo e(asset('assets/images/avatar_homem.png')); ?>"
                            >

                        <?php else: ?>
                            <img class="img-fluid card-img-top" src="<?php echo e(asset('assets/images/avatar_mulher.jpg')); ?>"
                           >

                        <?php endif; ?>
                    <?php else: ?>
                        <img class="img-fluid card-img-top" src="<?php echo e(asset('storage/imagem_crianca/'.$crianca->imagem)); ?>"
                        >
                    <?php endif; ?>

                    <div class="card-body">
                        <h5 class="card-title"><?php echo e($crianca->nome_completo); ?></h5>

                        <h5 class="card-title">Matriculado:
                            <?php if($crianca_matriculada != null): ?>
                                Matriculado
                            <?php else: ?>
                                Não Matriculado
                            <?php endif; ?>

                        </h5>


                    </div>
                </div>


                <div class="card col-md-8">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4 col-sm-12">
                                <ul class="nav flex-column nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                                    <li><a class="nav-link text-left active" id="v-pills-home-tab" data-toggle="pill" href="#v-pills-home" role="tab" aria-controls="v-pills-home" aria-selected="true">Dados Pessoais</a></li>
                                    <li><a class="nav-link text-left" id="v-pills-profile-tab" data-toggle="pill" href="#v-pills-profile" role="tab" aria-controls="v-pills-profile" aria-selected="false">Responsaveis</a></li>
                                    <li><a class="nav-link text-left" id="v-pills-messages-tab" data-toggle="pill" href="#v-pills-messages" role="tab" aria-controls="v-pills-messages" aria-selected="false">Dados Academicos</a></li>
                                </ul>
                            </div>
                            <div class="col-md-8 col-sm-12">
                                <div class="tab-content" id="v-pills-tabContent">
                                    <div class="tab-pane fade show active" id="v-pills-home" role="tabpanel" aria-labelledby="v-pills-home-tab">
                                        <h6 class="mb-3">Nome: <?php echo e($crianca->nome_completo); ?></h6>
                                        <h6 class="mb-3">Gênero:
                                            <?php if($crianca->genero == "M"): ?>
                                                Masculino
                                            <?php else: ?>
                                                Feminino
                                            <?php endif; ?>
                                        </h6>
                                        <h6 class="mb-3">Data de Nascimento: <?php echo e($crianca->data_nascimento); ?></h6>
                                        <h6 class="mb-3">Idade: <?php echo e($crianca->idade); ?></h6>
                                        <h6 class="mb-3">Cédula: <?php echo e($crianca->bi_cedula); ?></h6>
                                        <h6 class="mb-3">Certidão:
                                            <?php if($crianca->certidao == null || $crianca->certidao == "null"): ?>
                                               <label class="badge badge-light-danger">Não Registado</label>
                                            <?php else: ?>

                                                 <button data-toggle="modal" data-target="#ver_certidao" class="btn btn-sm btn-secondary">Visualizar</button>

                                            <?php endif; ?>
                                        </h6>
                                        <h6 class="mb-3">Cartão de Vacina:
                                            <?php if($crianca->cartao_vacina == null || $crianca->cartao_vacina == "null"): ?>
                                                <label class="badge badge-light-danger">Não Registado</label>
                                            <?php else: ?>

                                                <button data-toggle="modal" data-target="#ver_cartao"  class="btn btn-sm btn-secondary">Visualizar</button>

                                            <?php endif; ?>

                                        </h6>

                                    </div>

                                    <div class="tab-pane fade" id="v-pills-profile" role="tabpanel" aria-labelledby="v-pills-profile-tab">
                                        <h6 class="mb-3">Responsavel: <?php echo e($crianca->responsavel1); ?></h6>
                                        <h6 class="mb-3">Grau: <?php echo e($crianca->grau); ?></h6>
                                        <h6 class="mb-3">Contacto: <?php echo e($crianca->contacto); ?></h6>
                                        <h6 class="mb-3">Endereço: <?php echo e($crianca->endereco); ?></h6>
                                    </div>
                                    <div class="tab-pane fade" id="v-pills-messages" role="tabpanel" aria-labelledby="v-pills-messages-tab">
                                        <h6 class="mb-3">Turma: <?php echo e($crianca->responsavel1); ?></h6>
                                        <h6 class="mb-3">Pagamento: <?php echo e($crianca->grau); ?></h6>
                                    </div>
                                    <button data-toggle="modal" data-target="#editar_crianca" class="btn btn-sm btn-primary float-right">Editar Dados</button>


                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <input type="text" id="crianca_reg"  hidden value="<?php echo e($crianca_reg); ?>" >
                <input type="text" id="identificacao"  hidden value="<?php echo e($crianca->bi_cedula); ?>" >
        </div>

        <div class="row">

            <div class="col-xl-12">

                <?php if($errors->any()): ?>

                    <div class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                        <span class="badge badge-pill badge-danger">Erro</span>
                        <ul class="errors">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $erro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li> <?php echo e($erro); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
            <?php endif; ?>

                <?php if(session()->has('sms')): ?>
                    <div class="sufee-alert alert with-close alert-success alert-dismissible fade show">
                        <span class="badge badge-pill badge-success">Successo</span>
                        <?php echo e(session()->get('sms')); ?>

                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                <?php endif; ?>


                <div class="card">
                    <div class="card-header">
                        <h5>Histórico de Pagamentos</h5><br>

                   </div>
                    <div class="card-body table-border-style">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Mês Pago</th>
                                        <th>Valor Pago</th>
                                        <th>Ano Lectivo</th>
                                        <th>Comprovativo</th>
                                        <th>Data do Pagamento</th>


                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $pagamento; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pagamento): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <tr>

                                       
                                            <td>
                                                <?php echo e($pagamento->mes_pago); ?>

                                            </td>
                                            <td><?php echo e($pagamento->valor_pago); ?> </td>
                                            <td><?php echo e($pagamento->ano_lectivo); ?> </td>
                                            <td style="text-align: center; size:100px">
                                                <?php if($pagamento->comprovativo != 'null'): ?>
                                                    <button  onclick="ver_comprovativo(<?php echo e(json_encode($pagamento->comprovativo)); ?>)"    data-toggle="modal" data-target="#ver_comprovativo"  class="btn btn-sm btn-secondary"><i style="color:red" class="fa fa-file"></i></button>
                                                <?php endif; ?>
                                            </td>
                                            <td > <?php echo e($pagamento->created_at); ?></td>

                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </div>
</div>


<div id="editar_crianca" class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title h4" id="myLargeModalLabel">Editar Dados da Criança</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <div  id="sms_erro" class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                    <span class="badge badge-pill badge-danger">Erro</span>
                   Preencha todos os campos obrigatórios.

                </div>


                <div  id="sms_erro4" class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                    <span class="badge badge-pill badge-danger">Erro</span>
                   Número de Telefone inválido.

                </div>
                <div  id="sms_erro5" class="sufee-alert alert with-close alert-danger alert-dismissible fade show">
                    <span class="badge badge-pill badge-danger">Erro</span>
                   Número de identificação já associado.

                </div>

                <div class="modal-body">
                    <form id="formulario" action="<?php echo e(route('editar.crianca')); ?>" method="post" enctype="multipart/form-data" >
                       <?php echo csrf_field(); ?>
                        <h6 style="color: black">Informaçoes Pessoais</h6>

                        <div class="form-row">

                            <div class="form-group col-md-12">
                                <label for="inputCity">Nome Completo <span style="color: red">*</span> </label>
                                <input type="text" id="nome" name="nome" value=" <?php echo e($crianca->nome_completo); ?>" class="form-control">
                                <input hidden name="id_pessoa" value=" <?php echo e($crianca->id); ?>" type="text">
                                <input hidden name="id_crianca" value=" <?php echo e($crianca->id_crianca); ?>" type="text">

                            </div>

                            <div class="form-group col-md-4">
                                <label for="inputZip">Data de Nascimento <span style="color: red">*</span></label>
                                <input value="<?php echo e($crianca->data_nascimento); ?>"  type="date" id="data_nascimento" max="<?php echo e(date('Y-m-d')); ?>"  name="data_nascimento" class="form-control" >
                                <small id="data_nascimento_erro" style="color: red; display: none;"></small>

                            </div>
                            <div class="form-group col-md-4">
                                <label for="inputZip">Cédula  <span style="color: red">*</span></label>
                                <input value="<?php echo e($crianca->bi_cedula); ?>" type="text" id="cedula" name="cedula" class="form-control" value="CI-" maxlength="13" required>
                                <small id="cedula-error" style="color: red; display: none;">Formato inválido! O formato deve ser 'CI-XXXXXXX/XX'.</small>

                            </div>

                            <div class="form-group col-md-4">
                                <label for="inputState">Gênero <span style="color: red">*</span></label>
                                <select id="genero" name="genero" class="form-control">
                                    <option value="<?php echo e($crianca->genero); ?>" ><?php echo e($crianca->genero); ?></option>
                                    <option value="M">Masculino</option>
                                    <option value="F">Feminino</option>
                                </select>
                            </div>
                        </div>
                        <h6 style="color: black">Informaçoes dos Responsaveis</h6>

                        <div class="form-row">

                            <div class="form-group col-md-12">
                                <label for="inputCity">Nome <span style="color: red">*</span> </label>
                                <input value="<?php echo e($crianca->responsavel1); ?>" type="text" id="nome_responsavel" name="nome_responsavel" class="form-control">

                            </div>

                            <div class="form-group col-md-4">
                                <label for="inputZip">Contacto <span style="color: red">*</span></label>
                                <input value="<?php echo e($crianca->contacto); ?>"  type="text" id="telefone" name="telefone" class="form-control" >
                            </div>
                            <div class="form-group col-md-4">
                                <label for="inputZip">Endereço <span style="color: red">*</span></label>
                                <input value="<?php echo e($crianca->endereco); ?>" type="text" id="endereco" name="endereco" class="form-control" >
                            </div>
                            <div class="form-group col-md-4">
                                <label for="inputState">Relação <span style="color: red">*</span></label>
                                <select  id="relacao" name="relacao" class="form-control">
                                    <option value="<?php echo e($crianca->grau); ?>"><?php echo e($crianca->grau); ?></option>
                                    <option value="Pai">Pai</option>
                                    <option value="Mãe">Mãe</option>
                                    <option value="Irmão">Irmão</option>
                                    <option value="Irmã">Irmã</option>
                                    <option value="Outro">Outro</option>
                                </select>
                            </div>
                        </div>
                        <h6 style="color: black">Documentos</h6>
                        <div class="form-row">
                            <div class="form-group col-md-4">
                                <label for="inputCity">Certidão de Nascimento </label>
                                <input type="file" id="certidao" name="certidao" class="form-control" accept=".doc, .docx, .pdf">

                            </div>
                            <div class="form-group col-md-4">
                                <label for="inputCity">Cartão de Vacina</label>
                                <input type="file" id="cartao_vacina" name="cartao_vacina" class="form-control" accept=".doc, .docx, .pdf">

                            </div>
                            <div class="form-group col-md-4">
                                <label for="inputCity">Imagem</label>
                                <input type="file" id="imagem" name="imagem" class="form-control" accept="image/*">

                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn  btn-secondary" data-dismiss="modal">Fechar</button>
                            <button onclick="verificarRegisto()"  class="btn  btn-primary">Confirmar</button>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>
</div>



<div id="ver_certidao" class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title h4" id="myLargeModalLabel">Certidão</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <div class="modal-body">

                    <iframe src="<?php echo e(asset('storage/documentos_crianca/'.$crianca->certidao)); ?>"
                        style="width: 100%; height: 500px; border: none;">
                </iframe>

                    <div class="modal-footer">
                        <button type="button" class="btn  btn-secondary" data-dismiss="modal">Fechar</button>
                    </div>

                </div>

            </div>
        </div>
    </div>
</div>

<div id="ver_cartao" class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title h4" id="myLargeModalLabel">Certão de Vacina</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <div class="modal-body">

                    <iframe src="<?php echo e(asset('storage/documentos_crianca/'.$crianca->cartao_vacina)); ?>"
                        style="width: 100%; height: 500px; border: none;">
                </iframe>

                    <div class="modal-footer">
                        <button type="button" class="btn  btn-secondary" data-dismiss="modal">Fechar</button>
                    </div>

                </div>

            </div>
        </div>
    </div>
</div>




<div id="ver_comprovativo" class="modal fade bd-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title h4" id="myLargeModalLabel">Comprovativo</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <div class="modal-body" id="comprovativo_doc">

                    <iframe src=""
                        style="width: 100%; height: 500px; border: none;">
                </iframe>

                    <div class="modal-footer">
                        <button type="button" class="btn  btn-secondary" data-dismiss="modal">Fechar</button>
                    </div>

                </div>

            </div>
        </div>
    </div>
</div>



<script>
    document.getElementById('sms_erro').style.display = 'none';
    document.getElementById('sms_erro4').style.display = 'none';
    document.getElementById('sms_erro5').style.display = 'none';

    function verificarRegisto(){
        event.preventDefault();

        var nome_completo = document.getElementById('nome').value;
        var genero = document.getElementById('genero').value;
        var telefone = document.getElementById('telefone').value;
        var cedula = document.getElementById('cedula').value;
        var data_nascimento = document.getElementById('data_nascimento').value;
        var nome_responsavel = document.getElementById('nome_responsavel').value;
        var endereco = document.getElementById('endereco').value;
        var relacao = document.getElementById('relacao').value;

        if(cedula ==='' || cedula ==='CI-/' ||  cedula ==='CI-'|| nome_completo ==='' || endereco ==='' || relacao ==='' || data_nascimento ==='' || genero ==='' || nome_responsavel ==='' || telefone ===''){
            document.getElementById('sms_erro').style.display = 'block';

        }else{
            document.getElementById('sms_erro').style.display = 'none';

            if(verificarTelefone(telefone)=== false){
                document.getElementById('sms_erro4').style.display = 'block';
            }else if(verificar_cedula_registado(cedula)===true){
                document.getElementById('sms_erro5').style.display = 'block';
            }else{
                document.getElementById('sms_erro5').style.display = 'none';
                document.getElementById('sms_erro4').style.display = 'none';
                document.getElementById('formulario').submit();
            }
        }
    }

    function verificarTelefone(telefone) {

        const padrao = /^(9)[0-9]{8}$/;

        if (padrao.test(telefone)) {

            return true;
        }

        return false;
    }

    function verificarCedula(bi) {
        const padrao = /^CI-\d{7}\/\d{2}$/;
        bi = bi.toUpperCase();

        if (bi.length === 14) {
            if (padrao.test(bi)) {

            return true;
            }

        }

    return false;
    }


    function ver_comprovativo(comprovativo){

        const comprovativoPath = `/storage/documentos_pagamento/${comprovativo}`;
        document.getElementById('comprovativo_doc').querySelector('iframe').src = comprovativoPath;

        //$('#ver_cartao').modal('show');
    }


    function verificar_cedula_registado(bi){
        const func_reg = JSON.parse(document.getElementById('crianca_reg').value);
        const identificacao = document.getElementById('identificacao').value;

        for(let i = 0; i < func_reg.length; i++){
            if(bi === func_reg[i].bi_cedula && identificacao != bi){
                return true;
            }

        }
        return false;
    }


    const cedulaInput = document.getElementById('cedula');
  const errorMessage = document.getElementById('cedula-error');

  // Função para formatar o número da cédula enquanto o usuário digita
  cedulaInput.addEventListener('input', function () {
    // Remove qualquer caractere não numérico (exceto a barra "/")
    const value = cedulaInput.value.replace(/[^0-9]/g, '');

    // Limita a quantidade de caracteres para 7 números e 2 após a barra
    const formattedValue = `CI-${value.slice(0, 7)}/${value.slice(7, 9)}`;

    cedulaInput.value = formattedValue;

    // Exibe erro se o valor não estiver completo
    if (!/^CI-\d{7}\/\d{2}$/.test(formattedValue)) {
      errorMessage.style.display = 'block';
    } else {
      errorMessage.style.display = 'none';
    }
  });





  document.getElementById('data_nascimento').addEventListener('input', function() {

    if (this.value.split("-")[0] < 1000) {
        return;
    }

    const dataNascimento = new Date(this.value);
        const dataAtual = new Date();

        // Calcular limites de idade
        const dataMinima = new Date();
        dataMinima.setFullYear(dataAtual.getFullYear() - 6);

        const dataMaxima = new Date();
        dataMaxima.setFullYear(dataAtual.getFullYear() - 3);

        const mensagemErro = document.getElementById('data_nascimento_erro');

        // Verifica se a data é válida
        if (isNaN(dataNascimento.getTime())) {
            mensagemErro.textContent = 'Data inválida. Por favor, insira uma data válida.';
            mensagemErro.style.display = 'block';
            this.value = '';
            return;
        }

        if (dataNascimento < dataMinima) {
            mensagemErro.textContent = 'A idade máxima permitida é de 6 anos.';
            mensagemErro.style.display = 'block';
            this.value = '';
        } else if (dataNascimento > dataMaxima) {
            mensagemErro.textContent = 'A idade mínima permitida é de 3 anos.';
            mensagemErro.style.display = 'block';
            this.value = '';
        } else {
            mensagemErro.style.display = 'none';
        }
    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('Dashboard.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\Ferdinando Roque\Documents\GitHub\creche\resources\views/Dashboard/pagina/perfil_crianca.blade.php ENDPATH**/ ?>